/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.amqp;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.service.ApplicationConfigurationService;
import com.deutscheboerse.comxerv.comtrader.service.amqp.AbstractAmqpBackend;
import com.deutscheboerse.comxerv.comtrader.service.amqp.AmqpBroadcastListener;
import com.deutscheboerse.comxerv.comtrader.service.amqp.BroadcastQueueListener;
import com.deutscheboerse.comxerv.comtrader.service.amqp.MessageSequenceCheck;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Delivery;
import com.rabbitmq.client.Envelope;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceCheckBroadcastListener
implements AmqpBroadcastListener {
    private static final Logger LOG = LoggerFactory.getLogger(SequenceCheckBroadcastListener.class);
    private final BroadcastQueueListener wrappedListener;
    private final AbstractAmqpBackend abstractAmqpBackend;
    private boolean isMessageGapRecoveryEnabled;
    private boolean isMessageGapRecovery;
    private final Map<String, SortedSet<Delivery>> messagesPerTopic = new HashMap<String, SortedSet<Delivery>>();

    public SequenceCheckBroadcastListener(ApplicationContext appContext, AbstractAmqpBackend abstractAmqpBackend, BroadcastQueueListener wrapped) {
        this.abstractAmqpBackend = abstractAmqpBackend;
        this.wrappedListener = wrapped;
        this.isMessageGapRecoveryEnabled = appContext.getService(ApplicationConfigurationService.class).getBooleanApplicationProperty("withMessageGapRecovery");
    }

    @Override
    public boolean handleAmqpConnectionError(Exception e) {
        return this.wrappedListener.handleAmqpConnectionError(e);
    }

    @Override
    public void processBroadcast(Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException, ClassNotFoundException {
        this.abstractAmqpBackend.checkMessageDelay(properties, body.length);
        MessageSequenceCheck.Result gapDetectedResult = this.abstractAmqpBackend.checkMessageSequence(properties);
        if (gapDetectedResult.isGapDetected()) {
            if (!this.isMessageGapRecoveryEnabled) {
                this.abstractAmqpBackend.notifyGapDetected(this.abstractAmqpBackend.getGapDetectionNotification(gapDetectedResult));
            } else {
                if (!this.isMessageGapRecovery) {
                    LOG.info("Starting gap recovery mode");
                    this.isMessageGapRecovery = true;
                    this.abstractAmqpBackend.startMessageSequenceRecoveryTimer(this::getResults);
                }
                this.messagesPerTopic.computeIfAbsent(gapDetectedResult.getTopic(), key -> new TreeSet<Delivery>(Comparator.comparing(this::getSeqNumber))).add(new Delivery(envelope, properties, body));
            }
        } else {
            this.wrappedListener.processBroadcast(envelope, properties, body);
            if (this.isMessageGapRecovery) {
                this.tryToRecoverFromGaps(gapDetectedResult);
            }
        }
    }

    private void tryToRecoverFromGaps(MessageSequenceCheck.Result gapDetectedResult) {
        SortedSet<Delivery> messages = this.messagesPerTopic.get(gapDetectedResult.getTopic());
        if (messages != null) {
            Delivery delivery;
            MessageSequenceCheck.Result result;
            Iterator it = messages.iterator();
            while (it.hasNext() && !(result = this.abstractAmqpBackend.checkMessageSequence((delivery = (Delivery)it.next()).getProperties())).isGapDetected()) {
                this.wrappedListener.processBroadcast(delivery.getEnvelope(), delivery.getProperties(), delivery.getBody());
                it.remove();
            }
            if (messages.isEmpty()) {
                this.messagesPerTopic.remove(gapDetectedResult.getTopic());
            }
            if (this.messagesPerTopic.isEmpty()) {
                LOG.info("Ending gap recovery mode");
                this.isMessageGapRecovery = false;
                this.abstractAmqpBackend.stop();
            }
        }
    }

    private Collection<MessageSequenceCheck.Result> getResults() {
        return this.messagesPerTopic.values().stream().map(SortedSet::first).map(delivery -> this.abstractAmqpBackend.checkMessageSequence(delivery.getProperties())).filter(MessageSequenceCheck.Result::isGapDetected).toList();
    }

    public void stop() {
        this.wrappedListener.stop();
        this.messagesPerTopic.clear();
        this.isMessageGapRecovery = false;
        this.abstractAmqpBackend.stop();
    }

    public void startProcessBroadcast() {
        this.wrappedListener.startProcessBroadcast();
    }

    private Long getSeqNumber(Delivery delivery) {
        return (Long)delivery.getProperties().getHeaders().get(this.abstractAmqpBackend.getGroupSequence());
    }
}

