/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.async;

import com.deutscheboerse.comxerv.comtrader.module.WorkerExecutor;
import com.deutscheboerse.comxerv.comtrader.service.async.AsyncResponse;
import com.deutscheboerse.comxerv.comtrader.service.async.ErrorType;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseHandler;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseHandlerWithTimeout;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseStatus;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

@Singleton
public class ResponseHandlerWithTimeoutFactory {
    private static final int DEFAULT_GUI_RESPONSE_TIMEOUT = 30000;
    private final ScheduledExecutorService scheduledExecutorService;

    @Inject
    public ResponseHandlerWithTimeoutFactory(@WorkerExecutor ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = scheduledExecutorService;
    }

    public ResponseHandlerWithTimeout createHandler(ResponseHandler responseHandler, String correlationId) {
        AtomicBoolean lastResponseReceived = new AtomicBoolean(false);
        ResponseHandler responseHandlerWrapper = asyncResponse -> {
            lastResponseReceived.set(true);
            responseHandler.handleResponse(asyncResponse);
        };
        return this.createHandler(responseHandlerWrapper, correlationId, lastResponseReceived::get);
    }

    public ResponseHandlerWithTimeout createHandler(ResponseHandler responseHandler, String correlationId, Supplier<Boolean> lastResponseReceived) {
        return this.createHandler(responseHandler, correlationId, lastResponseReceived, 30000);
    }

    public ResponseHandlerWithTimeout createHandler(ResponseHandler responseHandler, String correlationId, Supplier<Boolean> lastResponseReceived, int timeoutInMillis) {
        return new ResponseHandlerWithTimeoutImpl(responseHandler, correlationId, timeoutInMillis, this.scheduledExecutorService, lastResponseReceived);
    }

    private static final class ResponseHandlerWithTimeoutImpl
    implements ResponseHandlerWithTimeout {
        private final ResponseHandler wrapped;
        private final String correlationId;
        private final int timeoutInMillis;
        private final ScheduledExecutorService scheduledExecutorService;
        private final Supplier<Boolean> lastResponseReceived;
        private ScheduledFuture<?> timeoutFuture;

        private ResponseHandlerWithTimeoutImpl(ResponseHandler wrapped, String correlationId, int timeoutInMillis, ScheduledExecutorService scheduledExecutorService, Supplier<Boolean> lastResponseReceived) {
            this.wrapped = wrapped;
            this.correlationId = correlationId;
            this.timeoutInMillis = timeoutInMillis;
            this.scheduledExecutorService = scheduledExecutorService;
            this.lastResponseReceived = lastResponseReceived;
        }

        @Override
        public void startTimeout(Runnable timeoutCallback) {
            Runnable timeoutHandler = () -> {
                if (!this.lastResponseReceived.get().booleanValue()) {
                    FxUtil.runInFxThread(() -> this.wrapped.handleResponse(new AsyncResponse(ResponseStatus.ERROR, null, Util.getLabel("commons_timeoutMessage", this.correlationId), ErrorType.TIMEOUT)));
                    timeoutCallback.run();
                }
            };
            this.timeoutFuture = this.scheduledExecutorService.schedule(timeoutHandler, (long)this.timeoutInMillis, TimeUnit.MILLISECONDS);
        }

        @Override
        public void handleResponse(AsyncResponse response) {
            this.wrapped.handleResponse(response);
        }

        @Override
        public boolean cancel() {
            return this.timeoutFuture != null && this.timeoutFuture.cancel(false);
        }
    }
}

