/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.csv.common;

import com.deutscheboerse.comxerv.comtrader.core.ActiveExchange;
import com.deutscheboerse.comxerv.comtrader.service.LocalService;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.AbstractColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.ExportColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.ImportException;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import org.joda.time.DateTime;

public abstract class DateTimeColumn<E>
extends AbstractColumn<DateTime>
implements ExportColumn<DateTime, E> {
    private final LocalService localService;
    private final ActiveExchange activeExchange;

    public DateTimeColumn(String header, LocalService localService, ActiveExchange activeExchange) {
        super(header, DateTime.class);
        this.localService = localService;
        this.activeExchange = activeExchange;
    }

    public DateTime parseDateValue(String data) throws ImportException {
        if (data == null || data.isEmpty()) {
            return null;
        }
        DateTime dateTime = this.localService.getJodaDateFormat().parseSimpleDateFormat(data, this.activeExchange.getActiveExchange().get().getSystemInfo().getTimeZone());
        if (dateTime != null) {
            return dateTime;
        }
        throw new ImportException("Could not parse number value " + data, Util.getLabel("importException_parseError", data, this.getHeader()));
    }

    @Override
    public String getStringValue(DateTime value) {
        return this.localService.getJodaDateFormat().printSimpleDateFormat(value);
    }
}

