/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.csv.order;

import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.type.ExecutionRestriction;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.ImportColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.ImportException;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.OrderRestrictionColumn;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.validation.ValidationMessage;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import java.util.Arrays;
import java.util.Collection;

public class OrderOrderRestrictionColumn
extends OrderRestrictionColumn<Order>
implements ImportColumn<ExecutionRestriction, Order> {
    public OrderOrderRestrictionColumn(String header) {
        super(header);
    }

    @Override
    public void applyValue(ExecutionRestriction value, Order importedObject) {
        importedObject.setExecutionRestriction(value);
    }

    @Override
    public ExecutionRestriction parseValue(String data) throws ImportException {
        try {
            return (ExecutionRestriction)this.parseNamedTypeValue(data);
        }
        catch (ImportException e) {
            throw new ImportException("Invalid ExeRes.", Util.getLabel("commons_invalidExeRes"));
        }
    }

    @Override
    public ExecutionRestriction getValue(Order objectToExport) {
        return objectToExport.getExecutionRestriction();
    }

    @Override
    public Collection<String> getErrorCodesKeys() {
        return Arrays.asList(ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_EXEC_RES.getMessageKey());
    }
}

