/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.csv.order;

import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.ImportColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.ImportException;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.LongDisplayValueColumn;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.validation.ValidationMessage;
import java.util.Arrays;
import java.util.Collection;

public class OrderStopPriceColumn
extends LongDisplayValueColumn<Order>
implements ImportColumn<LongDisplayValue, Order> {
    public OrderStopPriceColumn(String header) {
        super(header);
    }

    @Override
    public LongDisplayValue getValue(Order objectToExport) {
        return objectToExport.getStopPrice();
    }

    @Override
    public LongDisplayValue parseValue(String data) throws ImportException {
        return this.parseLongDisplayValue(data);
    }

    @Override
    public void applyValue(LongDisplayValue value, Order importedObject) {
        importedObject.setStopPrice(value);
    }

    @Override
    public Collection<String> getErrorCodesKeys() {
        return Arrays.asList(ValidationMessage.ORDER_VALIDATION_ERROR_SPRC_NOT_SUPPORTED.getMessageKey(), ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_STOP_PRICE.getMessageKey(), ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_SPRC.getMessageKey(), ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_SPRC_GRATER_THEN_LIMIT_PRC.getMessageKey(), ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_SPRC_LOWER_THEN_LIMIT_PRICE.getMessageKey());
    }
}

