/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.csv.order;

import com.deutscheboerse.comxerv.comtrader.core.ActiveExchange;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.service.LocalService;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.DateTimeColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.ImportColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.ImportException;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.validation.ValidationMessage;
import java.util.Arrays;
import java.util.Collection;
import org.joda.time.DateTime;

public class OrderValidityDateColumn
extends DateTimeColumn<Order>
implements ImportColumn<DateTime, Order> {
    public OrderValidityDateColumn(String header, LocalService localService, ActiveExchange activeExchange) {
        super(header, localService, activeExchange);
    }

    @Override
    public DateTime getValue(Order objectToExport) {
        return objectToExport.getValidityDate();
    }

    @Override
    public DateTime parseValue(String data) throws ImportException {
        return this.parseDateValue(data);
    }

    @Override
    public void applyValue(DateTime value, Order importedObject) {
        importedObject.setValidityDate(value);
    }

    @Override
    public Collection<String> getErrorCodesKeys() {
        return Arrays.asList(ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_VAL_DATE.getMessageKey(), ValidationMessage.ORDER_VALIDATION_ERROR_REDUNDANT_VAL_DATE.getMessageKey());
    }
}

