/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.orderentry.basket;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.BasketEntry;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.entities.type.BasketRestriction;
import com.deutscheboerse.comxerv.comtrader.entities.type.ExecutionRestriction;
import com.deutscheboerse.comxerv.comtrader.entities.type.ValidityRestriction;
import com.deutscheboerse.comxerv.comtrader.service.UserAlertService;
import com.deutscheboerse.comxerv.comtrader.service.async.AsyncResponse;
import com.deutscheboerse.comxerv.comtrader.service.async.ErrorType;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseHandler;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseStatus;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.basket.AllOrdersFOKBinding;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.basket.AllOrdersLinkedEnabledBinding;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.basket.AllOrdersREGBinding;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.basket.BasketFullException;
import com.deutscheboerse.comxerv.comtrader.service.time.TimeService;
import com.deutscheboerse.comxerv.comtrader.service.trade.TradingSettingsService;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import com.deutscheboerse.comxerv.comtrader.util.ApplicationPropertiesUtil;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import com.deutscheboerse.ui.jfx.util.binding.MappedObservableList;
import java.util.Optional;
import java.util.OptionalInt;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class Basket
implements ResponseHandler {
    public static final String BASKET_MAX_ORDERS = "basket_max_orders";
    public static final Integer MAX_ORDERS = Integer.valueOf(ApplicationPropertiesUtil.getApplicationProperty("basket_max_orders"));
    private final ObservableList<BasketEntry> entries = FXCollections.observableArrayList();
    private final ObservableList<Order> orders;
    private final BooleanProperty submitting;
    private final ObjectProperty<BasketRestriction> restriction;
    private final AllOrdersFOKBinding allFOK;
    private final AllOrdersLinkedEnabledBinding allOrdersLinkedEnabled;
    private final BooleanBinding switchAllToFOKDisabled;
    private final BooleanBinding linkedRestrictionAllowed;
    private final BooleanProperty addingNewEntriesAllowed;
    private final UserAlertService userAlertService;
    private final TradingSettingsService tradingSettingsService;
    private final ReadOnlyObjectProperty<User> currentUser;
    private final UserService userService;
    private final TimeService timeService;

    public Basket(ApplicationContext appContext) {
        this.timeService = appContext.getService(TimeService.class);
        this.userAlertService = appContext.getService(UserAlertService.class);
        this.tradingSettingsService = appContext.getService(TradingSettingsService.class);
        this.userService = appContext.getService(UserService.class);
        this.currentUser = this.userService.currentUserProperty();
        this.orders = MappedObservableList.get(this.entries, BasketEntry::getOrder);
        this.submitting = new SimpleBooleanProperty(false);
        this.restriction = new SimpleObjectProperty<BasketRestriction>(BasketRestriction.NONE);
        this.allFOK = new AllOrdersFOKBinding(this.orders);
        this.allOrdersLinkedEnabled = new AllOrdersLinkedEnabledBinding(this.entries, appContext.getDataModel(Product.class));
        this.linkedRestrictionAllowed = this.allFOK.and(this.allOrdersLinkedEnabled);
        this.linkedRestrictionAllowed.addListener((ChangeListener<? super Boolean>)((ChangeListener<Boolean>)(observable2, oldValue, newValue) -> {
            if (!newValue.booleanValue() && this.restriction.get() == BasketRestriction.LNK) {
                this.restriction.setValue(BasketRestriction.NONE);
            }
        }));
        this.switchAllToFOKDisabled = new AllOrdersREGBinding(this.orders).not().or(Bindings.isEmpty(this.orders));
        this.addingNewEntriesAllowed = new SimpleBooleanProperty();
        this.addingNewEntriesAllowed.bind(DependentBinding.get(this::isAddingNewEntriesAllowed, this.currentUser, this.entries, this.submitting));
    }

    private boolean isAddingNewEntriesAllowed() {
        return (this.userService.getCurrentUserRoles().isTrader() || this.userService.getCurrentUserRoles().isBalanceUser()) && this.entries.size() < MAX_ORDERS && !this.submitting.get();
    }

    public BooleanExpression submittable() {
        return Bindings.isNotEmpty(this.entries).and(this.submitting.not());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        ObservableList<BasketEntry> observableList = this.entries;
        synchronized (observableList) {
            this.entries.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Order order) throws BasketFullException {
        if (this.isFull()) {
            throw new BasketFullException("Basket already full: " + MAX_ORDERS, MAX_ORDERS);
        }
        this.preprocessOrder(order);
        ObservableList<BasketEntry> observableList = this.entries;
        synchronized (observableList) {
            this.entries.add(new BasketEntry(order, this.timeService.getServerTime()));
        }
    }

    public void markSubmitted() {
        this.submitting.setValue(true);
    }

    @Override
    public void handleResponse(AsyncResponse response) {
        switch (response.getStatus()) {
            case ACKNOWLEDGED: {
                this.handleAck();
                return;
            }
            case ERROR: {
                this.handleSuccessOrError(response);
                return;
            }
            case SUCCESS: {
                this.handleSuccessOrError(response);
            }
        }
    }

    private void handleAck() {
        if (!this.tradingSettingsService.isWaitForOrderConfirmation()) {
            this.clear();
            this.submitting.setValue(false);
        }
    }

    private void handleSuccessOrError(AsyncResponse response) {
        if (this.restriction.get() == BasketRestriction.NONE) {
            this.findIndexOfOrder(response.getClientOrderId()).ifPresent(this.entries::remove);
            if (ErrorType.CROSS_TRADE_PROTECTION_VETO.equals((Object)response.getErrorType())) {
                this.submitting.setValue(false);
            } else {
                this.submitting.setValue(this.tradingSettingsService.isWaitForOrderConfirmation() && !this.entries.isEmpty());
            }
        } else if (this.submitting().get()) {
            if (response.getStatus() == ResponseStatus.SUCCESS) {
                this.clear();
            }
            this.submitting.setValue(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Order order) {
        ObservableList<BasketEntry> observableList = this.entries;
        synchronized (observableList) {
            this.findIndexOfOrder(order).ifPresent(this.entries::remove);
        }
    }

    public void replaceWithUpdateVersion(Order order) throws BasketFullException {
        OptionalInt indexOfOrder = this.findIndexOfOrder(order);
        if (indexOfOrder.isPresent()) {
            this.preprocessOrder(order);
            this.entries.set(indexOfOrder.getAsInt(), new BasketEntry(order, this.timeService.getServerTime()));
        } else {
            this.add(order);
        }
    }

    private Optional<Order> findOrder(String clientOrderId) {
        return this.entries.stream().map(BasketEntry::getOrder).filter(order -> order.getClientOrderId().equals(clientOrderId)).findFirst();
    }

    private OptionalInt findIndexOfOrder(Order order) {
        return this.findIndexOfOrder(order.getClientOrderId());
    }

    private OptionalInt findIndexOfOrder(String clientOrderId) {
        return this.findOrder(clientOrderId).map(order -> OptionalInt.of(this.orders.indexOf(order))).orElse(OptionalInt.empty());
    }

    private void preprocessOrder(Order order) {
        if (order.getValidityRestriction() == ValidityRestriction.GOOD_FOR_SESSION || order.getValidityRestriction() == ValidityRestriction.NONE) {
            order.setValidityDate(null);
        }
        if (order.getClientOrderId() == null || order.getClientOrderId().isEmpty()) {
            order.initNewClientOrderId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(BasketEntry entry) {
        ObservableList<BasketEntry> observableList = this.entries;
        synchronized (observableList) {
            this.entries.remove(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ObservableList<BasketEntry> observableList = this.entries;
        synchronized (observableList) {
            this.entries.clear();
        }
        this.restriction.setValue(BasketRestriction.NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObservableList<BasketEntry> getEntries() {
        ObservableList<BasketEntry> observableList = this.entries;
        synchronized (observableList) {
            return FXCollections.unmodifiableObservableList(this.entries);
        }
    }

    public ObservableList<Order> getOrders() {
        return this.orders;
    }

    public boolean isFull() {
        return this.entries.size() >= MAX_ORDERS;
    }

    public void switchAllToFOK() {
        if (this.userAlertService.showQuestionDialog(Util.getLabel("basketPanel_switchAllToFOKQuestionHeader"), Util.getLabel("basketPanel_switchAllToFOKQuestionText"), new UserAlertService.Flag[0])) {
            this.entries.stream().map(BasketEntry::getOrder).forEach(this::switchToFOK);
            this.allFOK.invalidate();
        }
    }

    private void switchToFOK(Order order) {
        order.setExecutionRestriction(ExecutionRestriction.FILL_OR_KILL);
        order.setValidityRestriction(ValidityRestriction.NONE);
        order.setValidityDate(null);
        order.setAot(Boolean.FALSE);
    }

    public ObjectProperty<BasketRestriction> restrictionProperty() {
        return this.restriction;
    }

    public BooleanExpression linkedRestrictionAllowed() {
        return this.linkedRestrictionAllowed;
    }

    public BooleanExpression switchAllToFOKDisabled() {
        return this.switchAllToFOKDisabled;
    }

    public ReadOnlyBooleanProperty submitting() {
        return this.submitting;
    }

    public ReadOnlyBooleanProperty addingNewEntriesAllowed() {
        return this.addingNewEntriesAllowed;
    }
}

