/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.orderentry.protection;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.domain.query.OrderbookQueries;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookEntries;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookEntry;
import com.deutscheboerse.comxerv.comtrader.entities.type.ContractPhase;
import com.deutscheboerse.comxerv.comtrader.entities.type.Direction;
import com.deutscheboerse.comxerv.comtrader.entities.type.ExecutionRestriction;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderStatus;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderType;
import com.deutscheboerse.comxerv.comtrader.service.OwnQuantityLookupService;
import com.deutscheboerse.comxerv.comtrader.service.UserAlertService;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.protection.CrossTradeProtectionService;
import com.deutscheboerse.comxerv.comtrader.service.settings.SettingsService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

@Singleton
public class CrossTradeProtectionServiceImpl
implements CrossTradeProtectionService {
    private static final SettingsService.Settings<Boolean> CROSS_TRADE_PROTECTION_ENABLED_SETTINGS = new SettingsService.Settings<Boolean>("crossTradeProtection", true);
    private final UserAlertService userAlertService;
    private final SettingsService settingsService;
    private final OrderbookQueries orderbookQueries;
    private final ApplicationContext appContext;

    @Inject
    public CrossTradeProtectionServiceImpl(ApplicationContext appContext) {
        this.userAlertService = appContext.getService(UserAlertService.class);
        this.settingsService = appContext.getService(SettingsService.class);
        this.orderbookQueries = appContext.getService(OrderbookQueries.class);
        this.appContext = appContext;
    }

    @Override
    public boolean checkOrders(Collection<Order> orders, boolean askInCaseOfMatch) {
        List<Order> activeOrders = orders.stream().filter(order -> order.getStatus() == OrderStatus.ACTIVE).toList();
        boolean possibleOwnMatchingOrders = false;
        HashMap<Long, Order> checkedOrders = new HashMap<Long, Order>();
        for (Order order2 : activeOrders) {
            if (!this.checkInternOrder(order2, checkedOrders)) {
                possibleOwnMatchingOrders = true;
                break;
            }
            checkedOrders.put((Long)order2.getId(), order2);
        }
        return !possibleOwnMatchingOrders || askInCaseOfMatch && this.userAlertService.showQuestionDialog(Util.getLabel("commons_sendOrdersQuestion"), Util.getLabel("crossTradeProtectionService_orders_question"), new UserAlertService.Flag[0]);
    }

    @Override
    public boolean checkOrdersWithExclusion(Collection<Order> orders, boolean askInCaseOfMatch) {
        List<Order> activeOrders = orders.stream().filter(order -> order.getStatus() == OrderStatus.ACTIVE).toList();
        boolean possibleOwnMatchingOrders = false;
        HashMap<Long, Order> checkedOrders = new HashMap<Long, Order>();
        Set<Long> excludedOrders = activeOrders.stream().map(BroadcastEntity::getId).collect(Collectors.toSet());
        for (Order order2 : activeOrders) {
            if (!this.checkInternOrder(order2, checkedOrders, excludedOrders)) {
                possibleOwnMatchingOrders = true;
            }
            checkedOrders.put((Long)order2.getId(), order2);
        }
        return !possibleOwnMatchingOrders || askInCaseOfMatch && this.userAlertService.showQuestionDialog(Util.getLabel("commons_sendOrdersQuestion"), Util.getLabel("crossTradeProtectionService_orders_question"), new UserAlertService.Flag[0]);
    }

    @Override
    public boolean checkOrdersWithEachOther(Collection<Order> orders, boolean askInCaseOfMatch) {
        List<Order> activeOrders = orders.stream().filter(order -> order.getStatus() == OrderStatus.ACTIVE).toList();
        Predicate<Order> containsOpositeOrder = order -> activeOrders.stream().anyMatch(matchingOrder -> Objects.equals(order.getContractId(), matchingOrder.getContractId()) && Objects.equals(order.getDeliveryAreaId(), matchingOrder.getDeliveryAreaId()) && order.getDirection().reverse().equals(matchingOrder.getDirection()) && this.fitsAllOrNothingRestriction((Order)order, matchingOrder.getRemainingQuantity()) && this.checkPrice((Order)order, matchingOrder.getLimitPrice()));
        return !activeOrders.stream().anyMatch(containsOpositeOrder) || askInCaseOfMatch && this.userAlertService.showQuestionDialog(Util.getLabel("commons_sendOrdersQuestion"), Util.getLabel("crossTradeProtectionService_enteredOrders_questionHeader"), new UserAlertService.Flag[0]);
    }

    private boolean checkInternOrder(Order order, Map<Long, Order> checkedOrders, Set<Long> exceptionOrders) {
        if (!this.isEnabled() || OrderType.OTC_PREARRANGED.equals(order.getOrderType()) || ContractPhase.BALA.equals(order.getContract().getCompoundStatus().getTradingPhase()) || order.getProduct().isLiftOrderProduct() && OrderType.LIFT != order.getOrderType()) {
            return true;
        }
        OwnQuantityLookupService ownQuantityLookupService = this.appContext.getService(OwnQuantityLookupService.class);
        Set orderbookEntries = this.orderbookQueries.findByContractIdAndDeliveryAreaId(order.getContractId(), order.getDeliveryAreaId()).filter(orderbook -> !ContractPhase.BALA.equals(orderbook.getContract().getCompoundStatus().getTradingPhase())).map(orderbook -> Direction.BUY.equals(order.getDirection()) ? orderbook.getSells() : orderbook.getBuys()).map(OrderbookEntries::getEntries).orElse(Collections.emptySet());
        for (OrderbookEntry orderbookEntry : orderbookEntries) {
            Long possibleMatchOrderId = orderbookEntry.getOrderId();
            if (!ownQuantityLookupService.isOwnOrder(possibleMatchOrderId)) continue;
            Optional<Order> possibleMatch = Optional.ofNullable(checkedOrders.get(possibleMatchOrderId));
            LongDisplayValue possibleMatchPrice = possibleMatch.map(Order::getLimitPrice).orElse(orderbookEntry.getPrice());
            LongDisplayValue possibleMatchQuantity = possibleMatch.map(Order::getRemainingQuantity).orElse(orderbookEntry.getQuantity());
            if (!this.fitsAllOrNothingRestriction(order, possibleMatchQuantity) || !this.checkPrice(order, possibleMatchPrice)) continue;
            return exceptionOrders.contains(possibleMatchOrderId);
        }
        return true;
    }

    private boolean checkInternOrder(Order order, Map<Long, Order> checkedOrders) {
        return this.checkInternOrder(order, checkedOrders, Collections.emptySet());
    }

    private boolean fitsAllOrNothingRestriction(Order order, LongDisplayValue quantity) {
        return ExecutionRestriction.ALL_OR_NOTHING != order.getExecutionRestriction() || order.getRemainingQuantity().equals(quantity);
    }

    private boolean checkPrice(Order order, LongDisplayValue price) {
        int diff = price.compareTo(order.getLimitPrice());
        return Direction.BUY.equals(order.getDirection()) && diff <= 0 || Direction.SELL.equals(order.getDirection()) && diff >= 0;
    }

    @Override
    public boolean isEnabled() {
        return this.settingsService.loadSettings(CROSS_TRADE_PROTECTION_ENABLED_SETTINGS);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.settingsService.storeSettings(CROSS_TRADE_PROTECTION_ENABLED_SETTINGS, enabled);
    }
}

