/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.performancemonitoring;

import com.deutscheboerse.comxerv.comtrader.entities.session.Session;
import com.deutscheboerse.comxerv.comtrader.service.performancemonitoring.RequestClassifier;
import com.deutscheboerse.comxerv.comtrader.service.time.TimeService;
import com.deutscheboerse.comxerv.comtrader.util.ApplicationPropertiesUtil;
import com.deutscheboerse.m7.comtrader.remote.log.v2.data.Client;
import com.deutscheboerse.m7.comtrader.remote.log.v2.data.RequestDuration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class PerformanceStatisticsLog {
    protected static final String CLIENT_ID = "ComTrader";
    protected static final long PENDING_TIMEOUT_IN_MILLIS = 300000L;
    private final TimeService timeService;
    private final RequestClassifier requestClassifier;
    private final Map<String, RequestDuration> requests;
    private final Map<Long, String> correlationIdByEventIndexMap;
    private final Client client;

    public PerformanceStatisticsLog(TimeService timeService, RequestClassifier requestClassifier, Session session) {
        this.timeService = timeService;
        this.requestClassifier = requestClassifier;
        this.requests = new ConcurrentHashMap<String, RequestDuration>();
        this.correlationIdByEventIndexMap = new ConcurrentHashMap<Long, String>();
        this.client = new Client();
        this.client.setLoginName(session.getConnectionParameters().getRabbitUser());
        this.client.setExchangeId(session.getExchange().getMarketId());
        this.client.setEnvironmentId(session.getConnectionParameters().getEnvironmentId());
        this.client.setApiVersion(session.getExchange().getApiVersion());
        this.client.setClientId(CLIENT_ID);
        this.client.setClientVersion(ApplicationPropertiesUtil.getApplicationProperty("comtrader.version"));
    }

    public void handleRequest(String correlationId, Object request) {
        String operationType = this.requestClassifier.getOperationType(request);
        if (correlationId != null && !"OTHER".equals(operationType)) {
            RequestDuration requestDuration = new RequestDuration();
            requestDuration.setCorrelationId(correlationId);
            requestDuration.setSent(this.timeService.getLocalTime().getMillis());
            requestDuration.setType(operationType);
            this.requests.put(correlationId, requestDuration);
        }
    }

    public void handleResponse(String correlationId, Long eventIndex, Object response, Long pmiProcessingTime) {
        Optional<RequestDuration> requestDuration;
        if (correlationId == null) {
            correlationId = Optional.ofNullable(eventIndex).map(this.correlationIdByEventIndexMap::get).orElse(null);
        }
        if ((requestDuration = Optional.ofNullable(correlationId).map(this.requests::get)).isPresent()) {
            RequestClassifier.ResponseType responseType = this.requestClassifier.getResponseType(response);
            long timestamp = this.timeService.getLocalTime().getMillis();
            switch (responseType) {
                case ACK: {
                    requestDuration.get().setAck(timestamp);
                    if (pmiProcessingTime != null) {
                        requestDuration.get().setPmiProcessingTime(pmiProcessingTime);
                    }
                    return;
                }
                case EXECUTION: {
                    requestDuration.get().setExecution(timestamp);
                    if (eventIndex != null) {
                        this.correlationIdByEventIndexMap.put(eventIndex, correlationId);
                    }
                    return;
                }
                case ORDERBOOK: {
                    requestDuration.get().setOrderbook(timestamp);
                    return;
                }
            }
        }
    }

    public void handleBroadcast(String correlationId, Long eventIndex, Object broadcast) {
        this.handleResponse(correlationId, eventIndex, broadcast, null);
    }

    protected List<RequestDuration> collectAll() {
        ArrayList<RequestDuration> all2 = new ArrayList<RequestDuration>(this.requests.values());
        this.requests.clear();
        this.correlationIdByEventIndexMap.clear();
        return all2;
    }

    protected List<RequestDuration> collectAllExceptPending() {
        HashMap<String, RequestDuration> allExceptPending = new HashMap<String, RequestDuration>(this.requests);
        Iterator iterator2 = allExceptPending.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry requestDurationEntry = iterator2.next();
            if (!this.isPending((RequestDuration)requestDurationEntry.getValue())) continue;
            iterator2.remove();
        }
        allExceptPending.keySet().forEach(this.requests::remove);
        this.correlationIdByEventIndexMap.keySet().removeIf(eventIndex -> this.requests.containsKey(this.correlationIdByEventIndexMap.get(eventIndex)));
        return new ArrayList<RequestDuration>(allExceptPending.values());
    }

    private boolean isPending(RequestDuration requestDuration) {
        long now = this.timeService.getLocalTime().getMillis();
        boolean isStillWithinTimeout = requestDuration.getSent() + 300000L > now;
        return isStillWithinTimeout && (requestDuration.getAck() == null || requestDuration.getExecution() == null || requestDuration.getOrderbook() == null);
    }

    protected Client getClient() {
        return this.client;
    }
}

