/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.statistic;

import com.deutscheboerse.comxerv.comtrader.entities.HalfTrade;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import java.util.stream.Stream;

class OwnVolumeStatisticsValues {
    private LongDisplayValue totalOwnPurchaseQuantity = null;
    private LongDisplayValue totalOwnSellQuantity = null;
    private LongDisplayValue ownPurchaseQuantityByPriceMultiplicationProduct = null;
    private LongDisplayValue ownSellQuantityByPriceMultiplicationProduct = null;

    public OwnVolumeStatisticsValues(Stream<HalfTrade> halfTradesStream) {
        halfTradesStream.forEach(halfTrade -> {
            if (halfTrade.getDirection().isBuy()) {
                this.totalOwnPurchaseQuantity = this.nullSafeAdd(this.totalOwnPurchaseQuantity, halfTrade.getQuantity());
                this.ownPurchaseQuantityByPriceMultiplicationProduct = this.nullSafeAdd(this.ownPurchaseQuantityByPriceMultiplicationProduct, new LongDisplayValue(halfTrade.getQuantity().getDisplayValue().multiply(halfTrade.getPrice().getDisplayValue())));
            }
            if (halfTrade.getDirection().isSell()) {
                this.totalOwnSellQuantity = this.nullSafeAdd(this.totalOwnSellQuantity, halfTrade.getQuantity());
                this.ownSellQuantityByPriceMultiplicationProduct = this.nullSafeAdd(this.ownSellQuantityByPriceMultiplicationProduct, new LongDisplayValue(halfTrade.getQuantity().getDisplayValue().multiply(halfTrade.getPrice().getDisplayValue())));
            }
        });
    }

    private LongDisplayValue nullSafeAdd(LongDisplayValue a, LongDisplayValue b) {
        if (a == null) {
            return b;
        }
        return a.add(b.getDisplayValue());
    }

    public LongDisplayValue getTotalOwnPurchaseQuantity() {
        return this.totalOwnPurchaseQuantity;
    }

    public LongDisplayValue getTotalOwnSellQuantity() {
        return this.totalOwnSellQuantity;
    }

    public LongDisplayValue getOwnPurchaseQuantityByPriceMultiplicationProduct() {
        return this.ownPurchaseQuantityByPriceMultiplicationProduct;
    }

    public LongDisplayValue getOwnSellQuantityByPriceMultiplicationProduct() {
        return this.ownSellQuantityByPriceMultiplicationProduct;
    }
}

