/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.trade;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.type.LogoutActionType;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderType;
import com.deutscheboerse.comxerv.comtrader.service.ApplicationConfigurationService;
import com.deutscheboerse.comxerv.comtrader.service.UserAlertService;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.RequestType;
import com.deutscheboerse.comxerv.comtrader.service.settings.SettingsService;
import com.deutscheboerse.comxerv.comtrader.service.trade.TradingMouseActions;
import com.deutscheboerse.comxerv.comtrader.service.trade.TradingSettingsService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.List;

@Singleton
public class TradingSettingsServiceImpl
implements TradingSettingsService {
    private final SettingsService settingsService;
    private final UserAlertService userAlertService;
    private final ApplicationConfigurationService configurationService;
    private final SettingsService.Settings<Integer> tradeCancelPopupGroupLimitSettings;
    private static final SettingsService.Settings<Boolean> ORDER_ENTRY_CONFIRMATION_SETTING = new SettingsService.Settings<Boolean>("orderEntryConfirmationSetting", false);
    private static final SettingsService.Settings<Boolean> EXPAND_MARKET_OVERVIEW_ITEMS_ON_ADDING = new SettingsService.Settings<Boolean>("expandMarketOverviewItemsOnAddingSetting", false);
    private static final SettingsService.Settings<LogoutActionType> LOGOUT_SETTINGS_ENUM_SETTING = new SettingsService.Settings<LogoutActionType>("logoutTypeEnumSetting", DEFAULT_LOGOUT_TYPE);
    private static final SettingsService.Settings<Boolean> WAIT_FOR_ORDER_CONFIRMATION_SETTING = new SettingsService.Settings<Boolean>("waitForOrderConfirmation", false);
    private static final SettingsService.Settings<Boolean> BASKET_VALIDATION_SETTING = new SettingsService.Settings<Boolean>("basketValidation", true);
    private static final SettingsService.Settings<Boolean> DEFAULT_AOT_SETTING = new SettingsService.Settings<Boolean>("defaultAot", true);
    private static final SettingsService.Settings<TradingMouseActions> TRADING_MOUSE_ACTIONS_SETTINGS = new SettingsService.Settings<TradingMouseActions>("tradingMouseActions", DEFAULT_MOUSE_ACTIONS, TradingMouseActions.class);
    private static final Integer EMPTY_VALUE = -1;

    @Inject
    public TradingSettingsServiceImpl(ApplicationContext applicationContext) {
        this.settingsService = applicationContext.getService(SettingsService.class);
        this.userAlertService = applicationContext.getService(UserAlertService.class);
        this.configurationService = applicationContext.getService(ApplicationConfigurationService.class);
        this.tradeCancelPopupGroupLimitSettings = new SettingsService.Settings<Integer>("tradeCancelPopupGroupLimit", null){

            @Override
            public Integer getDefaultValue() {
                return TradingSettingsServiceImpl.this.configurationService.getBooleanApplicationProperty("groupTradeCancelPopup") ? TradingSettingsService.DEFAULT_GROUP_TRADE_CANCEL_POPUP : null;
            }
        };
    }

    @Override
    public void storeOrderEntryConfirmationSettings(Boolean enableOrderEntryConfirmation) {
        this.settingsService.storeSettings(ORDER_ENTRY_CONFIRMATION_SETTING, enableOrderEntryConfirmation);
    }

    @Override
    public boolean isOrderEntryConfirmationEnabled() {
        return this.settingsService.loadSettings(ORDER_ENTRY_CONFIRMATION_SETTING);
    }

    @Override
    public void storeExpandMarketOverviewItemsOnAdding(Boolean expandMarketOverviewItemsOnAdding) {
        this.settingsService.storeSettings(EXPAND_MARKET_OVERVIEW_ITEMS_ON_ADDING, expandMarketOverviewItemsOnAdding);
    }

    @Override
    public boolean isExpandMarketOverviewItemsOnAddingEnabled() {
        return this.settingsService.loadSettings(EXPAND_MARKET_OVERVIEW_ITEMS_ON_ADDING);
    }

    @Override
    public List<Order> showOrderConfirmationPopup(List<Order> unConfirmedOrders, RequestType requestType) {
        if (this.isOrderEntryConfirmationEnabled() && RequestType.DEACTIVATE != requestType && !unConfirmedOrders.isEmpty()) {
            boolean confirmed = unConfirmedOrders.size() == 1 ? this.showSingleOrderConfirmationPopup(unConfirmedOrders.get(0), requestType) : this.showMultiOrderConfirmationPopup(unConfirmedOrders, requestType);
            return unConfirmedOrders.stream().filter(o -> confirmed).toList();
        }
        return unConfirmedOrders;
    }

    private boolean showMultiOrderConfirmationPopup(Collection<Order> orders, RequestType requestType) {
        StringBuilder ordersText = new StringBuilder();
        for (Order o : orders) {
            if (OrderType.ICEBERG.equals(o.getOrderType())) {
                ordersText.append(Util.getLabel("tradingSettingsService_orderEntryConfirmation_basket_icb_order", o.getDirection().getDescription(), o.getContract().getName(), o.getRemainingQuantity().toString(), o.getPeakQuantity().toString(), o.getContract().getProduct().getQuantityUnit(), o.getLimitPrice().toString(), o.getContract().getProduct().getCurrencyCode(), o.getDeliveryArea().getDisplayName()));
            } else {
                ordersText.append(Util.getLabel("tradingSettingsService_orderEntryConfirmation_basket_Order", o.getDirection().getDescription(), o.getContract().getName(), o.getRemainingQuantity().toString(), o.getContract().getProduct().getQuantityUnit(), o.getLimitPrice().toString(), o.getContract().getProduct().getCurrencyCode(), o.getDeliveryArea().getDisplayName()));
            }
            ordersText.append("\n");
        }
        return this.userAlertService.showQuestionDialog(Util.getLabel("tradingSettingsService_orderEntryConfirmation_question_header"), Util.getLabel("tradingSettingsService_orderEntryConfirmation_basketQuestion", Util.getLabel(requestType.getLabelKey())), ordersText.toString(), false, new UserAlertService.Flag[0]);
    }

    private boolean showSingleOrderConfirmationPopup(Order o, RequestType requestType) {
        String questionText = OrderType.ICEBERG.equals(o.getOrderType()) ? Util.getLabel("tradingSettingsService_orderEntryConfirmation_icb_question", Util.getLabel(requestType.getLabelKey()), o.getDirection().getDescription(), o.getContract().getName(), o.getRemainingQuantity().toString(), o.getPeakQuantity().toString(), o.getContract().getProduct().getQuantityUnit(), o.getLimitPrice().toString(), o.getContract().getProduct().getCurrencyCode(), o.getDeliveryArea().getDisplayName()) : Util.getLabel("tradingSettingsService_orderEntryConfirmation_question", Util.getLabel(requestType.getLabelKey()), o.getDirection().getDescription(), o.getContract().getName(), o.getRemainingQuantity().toString(), o.getContract().getProduct().getQuantityUnit(), o.getLimitPrice().toString(), o.getContract().getProduct().getCurrencyCode(), o.getDeliveryArea().getDisplayName());
        return this.userAlertService.showQuestionDialog(Util.getLabel("tradingSettingsService_orderEntryConfirmation_question_header"), questionText, new UserAlertService.Flag[0]);
    }

    @Override
    public void storeLogoutSettings(LogoutActionType logoutActionType) {
        this.settingsService.storeSettings(LOGOUT_SETTINGS_ENUM_SETTING, logoutActionType);
    }

    @Override
    public LogoutActionType getLogoutSettings() {
        return this.settingsService.loadSettings(LOGOUT_SETTINGS_ENUM_SETTING);
    }

    @Override
    public boolean isWaitForOrderConfirmation() {
        return this.settingsService.loadSettings(WAIT_FOR_ORDER_CONFIRMATION_SETTING);
    }

    @Override
    public void storeWaitForOrderConfirmation(boolean waitForOrderConfirmation) {
        this.settingsService.storeSettings(WAIT_FOR_ORDER_CONFIRMATION_SETTING, waitForOrderConfirmation);
    }

    @Override
    public void storeBasketValidation(boolean basketValidation) {
        this.settingsService.storeSettings(BASKET_VALIDATION_SETTING, basketValidation);
    }

    @Override
    public boolean isBasketValidation() {
        return this.settingsService.loadSettings(BASKET_VALIDATION_SETTING);
    }

    @Override
    public void storeDefaultAot(boolean defaultAot) {
        this.settingsService.storeSettings(DEFAULT_AOT_SETTING, defaultAot);
    }

    @Override
    public boolean isDefaultAot() {
        return this.settingsService.loadSettings(DEFAULT_AOT_SETTING);
    }

    @Override
    public void storeMouseActionsSettings(TradingMouseActions actions) {
        this.settingsService.storeSettings(TRADING_MOUSE_ACTIONS_SETTINGS, actions);
    }

    @Override
    public TradingMouseActions getTradingMouseActions() {
        return this.settingsService.loadSettings(TRADING_MOUSE_ACTIONS_SETTINGS);
    }

    @Override
    public void storeTradeCancelPopupGroupLimit(Integer limit) {
        if (this.configurationService.getBooleanApplicationProperty("groupTradeCancelPopup")) {
            this.settingsService.storeSettings(this.tradeCancelPopupGroupLimitSettings, limit == null ? EMPTY_VALUE : limit);
        }
    }

    @Override
    public Integer getTradeCancelPopupGroupLimit() {
        Integer tradeCancelPopupGroupLimit = this.settingsService.loadSettings(this.tradeCancelPopupGroupLimitSettings);
        return EMPTY_VALUE.equals(tradeCancelPopupGroupLimit) ? null : tradeCancelPopupGroupLimit;
    }

    @Override
    public Integer getTradeCancelPopupGroupLimitDefault() {
        return this.tradeCancelPopupGroupLimitSettings.getDefaultValue();
    }
}

