/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.util;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.LocalDate;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public class DateTimeUtils {
    private DateTimeUtils() {
    }

    public static DateTime mapDateToDateTime(Date date, DateTimeZone zone) {
        return date != null ? new DateTime((Object)date, zone) : null;
    }

    public static LocalDate mapDateToLocalDate(Date date, DateTimeZone zone) {
        return date != null ? new LocalDate((Object)date, zone) : null;
    }

    public static Date mapDateTimeToDate(DateTime date) {
        return date != null ? date.toDate() : null;
    }

    public static DateTime mapLongToDateTime(Long date, DateTimeZone zone) {
        return date != null ? new DateTime((Object)date, zone) : null;
    }

    public static DateTime mapXMLGregorianCalenderToDateTime(XMLGregorianCalendar xmlGregorianCalendar, DateTimeZone zone) {
        return xmlGregorianCalendar != null ? new DateTime((Object)xmlGregorianCalendar.toGregorianCalendar().getTime(), zone) : null;
    }

    public static Long mapDateTimeToLong(DateTime date) {
        return date != null ? Long.valueOf(date.getMillis()) : null;
    }

    public static List<Interval> split(DateTime startTime, DateTime endTime, ReadableDuration sliceDuration) {
        ArrayList<Interval> result = new ArrayList<Interval>();
        DateTime sliceStart = startTime;
        DateTime sliceEnd = sliceStart.plus(sliceDuration);
        while (sliceStart.isBefore(endTime)) {
            result.add(new Interval((ReadableInstant)sliceStart, (ReadableInstant)sliceEnd));
            sliceStart = sliceEnd;
            sliceEnd = sliceStart.plus(sliceDuration);
        }
        return result;
    }

    public static Interval mapDatesToInterval(Date dateFrom, Date dateTo, DateTimeZone zone) {
        return new Interval((ReadableInstant)DateTimeUtils.mapDateToDateTime(dateFrom, zone), (ReadableInstant)DateTimeUtils.mapDateToDateTime(dateTo, zone));
    }

    public static ZonedDateTime toDateTime(Date date, ZoneId zone) {
        if (date == null) {
            return null;
        }
        return ZonedDateTime.ofInstant(date.toInstant(), zone != null ? zone : ZoneId.systemDefault());
    }
}

