/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.m7.trading.api;

import java.io.Serializable;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public enum ModificationType implements Serializable
{
    CREATED("CREA", "created"),
    CONFIRMED("CONF", "confirmed"),
    ACTIVE("ACTI", "active"),
    INACTIVE("IACT", "inactive"),
    USER_ADD("UADD", "user add"),
    SYSTEM_ADD("SADD", "system add"),
    ADMIN_ADD("AADD", "admin add"),
    USER_MODIFICATION("UMOD", "user modification"),
    SYSTEM_MODIFICATION("SMOD", "system modification"),
    ADMIN_MODIFICATION("AMOD", "admin modification"),
    USER_ACTIVATE("UACT", "user activate"),
    SYSTEM_ACTIVATE("SACT", "system activate"),
    ADMIN_ACTIVATE("AACT", "admin activate"),
    USER_DELETE("UDEL", "user delete"),
    SYSTEM_DELETE("SDEL", "system delete"),
    ADMIN_DELETE("ADEL", "admin delete"),
    USER_REJECT("UREJ", "user reject"),
    SYSTEM_REJECT("SREJ", "system reject"),
    ADMIN_REJECT("AREJ", "admin reject"),
    HIBERNATE("HIBE", "hibernate"),
    USER_HIBERNATE("UHIB", "user hibernate"),
    SYSTEM_HIBERNATE("SHIB", "system hibernate"),
    ADMIN_HIBERNATE("AHIB", "admin hibernate"),
    AUCTION("AUCT", "action"),
    RECALL_REQUEST("RREQ", "recall request"),
    RECALL_GRANTED("RGRA", "recall granted"),
    RECALL_REJECTED("RREJ", "recall rejected"),
    REQUEST_SENT_FOR_APPROVAL_TO_SOB("RSFA", "request sent for approval to SOB"),
    TRADE_CANCEL_REQUEST("CREQ", "trade cancel request"),
    TRADE_CANCEL_REJECTED("CREJ", "trade cancel rejected"),
    TRADE_CANCELLED("CNCL", "trade cancelled"),
    QUOTE_ADD("QADD", "quote add"),
    ORDER_FULLY_EXECUTED("FEXE", "order fully executed"),
    ORDER_PARTIALLY_EXECUTED("PEXE", "order partially executed"),
    QUOTE_FULLY_EXECUTED("QFEX", "quote fully executed"),
    QUOTE_PARTIALLY_EXECUTED("QPEX", "quote partially executed"),
    TRADE_CASH_SETTLEMENT("CSTL", "trade cash settlement"),
    TRADE_PHYSICAL_DELIVERY("PHYD", "trade physical delivery"),
    TRADE_FAHRPLAN_AND_CASH_SETTLEMENT("TSTL", "trade fahrplan and cash settlement"),
    LIMIT_CASH_RESET("LCAR", "limit cash reset"),
    LIMIT_COMMODITY_RESET("LCOR", "limit commodity reset"),
    CALL("CALL", "call"),
    FREEZE("FRZE", "freeze"),
    POST_TRADING("PTRD", "post trading"),
    ON_APPROVE("ONAP", "on approve"),
    RECEIVED("RECV", "received"),
    SUSPENDED("SUSP", "suspended"),
    UNSUSPENDED("UNSU", "unsuspended"),
    EMERGENCY_SUSPENDED("EMSU", "emergency suspended (ECC-Emergency Member Stop)"),
    PROTECTIVELY_SUSPENDED("PSUS", "protectively suspended"),
    ICEBERG_ADD("IADD", "iceberg add"),
    BALANCE("BALA", "balance"),
    EXTERNAL("EXTN", "external"),
    INIT("INIT", "initial settlement state"),
    SENDING_TO_SETTLEMENT("SNDG", "sending to settlement"),
    SENT("SENT", "sent"),
    ACKNOWLEDGED("ACKN", "acknowledged"),
    INFO("INFO", "info"),
    SOB_ERROR("SERR", "sob error"),
    SOB_NOT_AVAILABLE("SNAV", "sob not available"),
    UNKNOWN("UKNW", "unknown");

    private static final long serialVersionUID = 4223495872390485753L;
    private static final Set<ModificationType> USER_ACTIONS;
    private String value;
    private String description;
    private static Map<String, ModificationType> valueMap;
    private static Map<String, ModificationType> descriptionMap;

    private ModificationType(String value, String description) {
        this.value = value;
        this.description = description;
    }

    public String getValue() {
        return this.value;
    }

    public static ModificationType getType(String type) {
        ModificationType modificationType = valueMap.get(type);
        if (modificationType == null) {
            throw new IllegalArgumentException("No ModificationType \"" + type + "\"");
        }
        return modificationType;
    }

    public static ModificationType findWithDescription(String description) {
        ModificationType modificationType = descriptionMap.get(description.toLowerCase());
        if (modificationType == null) {
            throw new IllegalArgumentException("No ModificationType with description \"" + description + "\"");
        }
        return modificationType;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean in(ModificationType ... types) {
        if (types == null) {
            return false;
        }
        for (ModificationType modificationType : types) {
            if (this != modificationType) continue;
            return true;
        }
        return false;
    }

    public boolean isUserAction() {
        return USER_ACTIONS.contains(this);
    }

    static {
        USER_ACTIONS = EnumSet.of(USER_ACTIVATE, new ModificationType[]{USER_ADD, USER_DELETE, USER_HIBERNATE, USER_MODIFICATION, USER_REJECT});
        valueMap = new HashMap<String, ModificationType>();
        descriptionMap = new HashMap<String, ModificationType>();
        for (ModificationType modificationType : ModificationType.values()) {
            ModificationType prevValue = valueMap.put(modificationType.getValue(), modificationType);
            ModificationType prevDescription = descriptionMap.put(modificationType.getDescription().toLowerCase(), modificationType);
            if (prevValue == null && prevDescription == null) continue;
            throw new IllegalStateException("Duplicate key for ModificationType: " + modificationType.getValue());
        }
    }
}

