/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.m7.trading.api.type;

import com.deutscheboerse.m7.trading.api.type.StatusMessageScope;
import java.util.HashMap;
import java.util.Map;

public enum StatusMessageType {
    MSG_UNKNOWN("unknown", StatusMessageScope.PUBLIC, 0, StatusMessageScope.ADMIN),
    MSG_TEXT_PUBLIC("text", StatusMessageScope.PUBLIC, 1, StatusMessageScope.PUBLIC),
    MSG_TEXT_PRIVATE("text", StatusMessageScope.BALGRP_PRODUCT, 2, StatusMessageScope.PUBLIC_PRODUCT),
    MSG_TEXT_PRIVATE_BG("text", StatusMessageScope.BALGRP, 3, StatusMessageScope.PUBLIC),
    MSG_LOGIN("login", StatusMessageScope.BALGRP, 4, StatusMessageScope.ADMIN),
    MSG_MS_LOGIN("login", StatusMessageScope.ADMIN, 5, StatusMessageScope.NOBODY),
    MSG_LOGOUT("logout", StatusMessageScope.BALGRP, 6, StatusMessageScope.ADMIN),
    MSG_USER_LOGIN_MONITORING("login", StatusMessageScope.ADMIN, 7, StatusMessageScope.NOBODY),
    MSG_BG_INACTIVE("balgroup_inactivated", StatusMessageScope.BALGRP, 9, StatusMessageScope.ADMIN),
    MSG_BG_INACTIVE_MS("balgroup_inactivated_ms", StatusMessageScope.ADMIN, 10, StatusMessageScope.NOBODY),
    MSG_ORDER_ENTERED("x_order_entered", StatusMessageScope.BALGRP_PRODUCT, 11),
    MSG_ORDER_ON_BEHALF_ENTERED_ADMIN("order_on_behalf_entered_admin", StatusMessageScope.ADMIN_PRODUCT, 12),
    MSG_ORDER_ON_BEHALF_ENTERED_USER("order_on_behalf_entered_user", StatusMessageScope.BALGRP_PRODUCT, 13),
    MSG_ORDER_INDICATIVE_ENTERED("x_order_indicative_entered", StatusMessageScope.BALGRP_PRODUCT, 155),
    MSG_ORDER_INDICATIVE_ON_BEHALF_ENTERED_ADMIN("order_indicative_on_behalf_entered_admin", StatusMessageScope.ADMIN_PRODUCT, 156),
    MSG_ORDER_INDICATIVE_ON_BEHALF_ENTERED_USER("order_indicative_on_behalf_entered_user", StatusMessageScope.BALGRP_PRODUCT, 157),
    MSG_ORDER_MODIFIED("x_order_modified", StatusMessageScope.BALGRP_PRODUCT, 14),
    MSG_ORDER_ON_BEHALF_MODIFIED_ADMIN("x_order_modified_on_behalf_admin", StatusMessageScope.ADMIN_PRODUCT, 15),
    MSG_ORDER_ON_BEHALF_MODIFIED_USER("x_order_modified_on_behalf_user", StatusMessageScope.BALGRP_PRODUCT, 16),
    MSG_ORDER_MODIFY_ALREADY_EXECUTED("x_order_modify_already_executed", StatusMessageScope.BALGRP_PRODUCT, 17),
    MSG_ORDER_DELETED("x_order_deleted", StatusMessageScope.BALGRP_PRODUCT, 18),
    MSG_ORDER_ON_BEHALF_DELETED_ADMIN("x_order_deleted_on_behalf_admin", StatusMessageScope.ADMIN_PRODUCT, 19),
    MSG_ORDER_ON_BEHALF_DELETED_USER("x_order_deleted_on_behalf_user", StatusMessageScope.BALGRP_PRODUCT, 20),
    MSG_ORDER_INACTIVATE("x_order_inactivate", StatusMessageScope.BALGRP_PRODUCT, 21),
    MSG_ORDER_ON_BEHALF_INACTIVATE_ADMIN("x_order_inactivate_on_behalf_admin", StatusMessageScope.ADMIN_PRODUCT, 22),
    MSG_ORDER_ON_BEHALF_INACTIVATE_USER("x_order_inactivate_on_behalf_user", StatusMessageScope.BALGRP_PRODUCT, 23),
    MSG_ORDER_ENTERED_PREARRANGED("x_order_entered_pre", StatusMessageScope.BALGRP_PRODUCT, 24),
    MSG_ORDER_ENTERED_PREARRANGED_ON_BEHALF_ADMIN("x_order_entered_pre_on_behalf_admin", StatusMessageScope.ADMIN_PRODUCT, 25),
    MSG_ORDER_ENTERED_PREARRANGED_ON_BEHALF_USER("x_order_entered_pre_on_behalf_user", StatusMessageScope.BALGRP_PRODUCT, 26),
    MSG_ORDER_RECEIVED_PREARRANGED("x_order_received_pre", StatusMessageScope.BALGRP_PRODUCT, 27),
    MSG_ORDER_DELETED_PREARRANGED("x_order_deleted_pre", StatusMessageScope.BALGRP_PRODUCT, 28),
    MSG_ORDER_DELETED_PREARRANGED_ON_BEHALF_ADMIN("x_order_deleted_pre_on_behalf_admin", StatusMessageScope.ADMIN_PRODUCT, 29),
    MSG_ORDER_DELETED_PREARRANGED_ON_BEHALF_USER("x_order_deleted_pre_on_behalf_user", StatusMessageScope.BALGRP_PRODUCT, 30),
    MSG_ORDER_REVOKED_PREARRANGED("x_order_revoked_pre", StatusMessageScope.BALGRP_PRODUCT, 31),
    MSG_ORDER_MODIFIED_PREARRANGED("x_order_modified_pre", StatusMessageScope.BALGRP_PRODUCT, 32),
    MSG_ORDER_MODIFIED_PREARRANGED_ON_BEHALF_ADMIN("x_order_modified_pre_on_behalf_admin", StatusMessageScope.ADMIN_PRODUCT, 33),
    MSG_ORDER_MODIFIED_PREARRANGED_ON_BEHALF_USER("x_order_modified_pre_on_behalf_user", StatusMessageScope.BALGRP_PRODUCT, 34),
    MSG_ORDER_REJECTED("x_order_rejected", StatusMessageScope.BALGRP_PRODUCT, 35),
    MSG_ORDER_REJECTED_BEHALF_ADMIN("x_order_rejected_behalf_admin", StatusMessageScope.ADMIN_PRODUCT, 36),
    MSG_ORDER_REJECTED_BEHALF_TARGET("x_order_rejected_behalf_user", StatusMessageScope.BALGRP_PRODUCT, 37),
    MSG_ORDER_REJECTED_BEHALF_ORIGINATOR("x_order_rejected_behalf_originator", StatusMessageScope.BALGRP_PRODUCT, 38),
    MSG_ORDER_ACCEPTED("x_order_accepted", StatusMessageScope.BALGRP_PRODUCT, 39),
    MSG_ORDER_ACCEPTED_BEHALF_ADMIN("x_order_accepted_behalf_admin", StatusMessageScope.ADMIN_PRODUCT, 40),
    MSG_ORDER_ACCEPTED_BEHALF_TRADER("x_order_accepted_behalf_user", StatusMessageScope.BALGRP_PRODUCT, 41),
    MSG_ORDER_ACCEPTED_BEHALF_ORIGINATOR("x_order_accepted_behalf_originator", StatusMessageScope.BALGRP_PRODUCT, 42),
    MSG_ORDER_EXECUTED("x_exec_completely", StatusMessageScope.BALGRP_PRODUCT, 50),
    MSG_ORDER_EXECUTED_PARTIAL("x_exec_partial_remain", StatusMessageScope.BALGRP_PRODUCT, 51),
    MSG_ORDER_EXECUTED_PARTIAL_DELETED("x_exec_partial_del", StatusMessageScope.BALGRP_PRODUCT, 52),
    MSG_ORDER_EXECUTED_DELETED("x_no_exec_order_del", StatusMessageScope.BALGRP_PRODUCT, 53),
    MSG_TRADE_RECALL("recall_trade", StatusMessageScope.BALGRP_PRODUCT, 54),
    MSG_TRADE_RECALL_BEHALF("recall_trade_behalf", StatusMessageScope.BALGRP_PRODUCT, 55),
    MSG_TRADE_RECALL_PUBLIC("x_recall_trade_public", StatusMessageScope.PUBLIC_PRODUCT, 56),
    MSG_TRADE_RECALL_ACCEPTED("recall_trade_acc", StatusMessageScope.BALGRP_PRODUCT, 57),
    MSG_TRADE_RECALL_REJECTED("recall_trade_rej", StatusMessageScope.BALGRP_PRODUCT, 58),
    MSG_TRADE_RECALL_ACCEPTED_ADMIN("recall_trade_acc_admin", StatusMessageScope.ADMIN_PRODUCT, 59, StatusMessageScope.NOBODY),
    MSG_TRADE_RECALL_REJECTED_ADMIN("recall_trade_rej_admin", StatusMessageScope.ADMIN_PRODUCT, 60, StatusMessageScope.NOBODY),
    MSG_TRADE_RECALL_NOT_POSSIBLE("recall_not_possible", StatusMessageScope.BALGRP_PRODUCT, 61, StatusMessageScope.ADMIN),
    MSG_ADMIN_RECALL_TRADE("admin_recall_trade", StatusMessageScope.ADMIN_PRODUCT, 62, StatusMessageScope.NOBODY),
    MSG_ADMIN_RECALL_TRADE_ONBEHALF("admin_recall_trade_onbehalf", StatusMessageScope.ADMIN_PRODUCT, 63, StatusMessageScope.NOBODY),
    MSG_CAPACITY_RECALL_FAILED("capacity_recall_failed", StatusMessageScope.ADMIN_PRODUCT, 64, StatusMessageScope.NOBODY),
    MSG_CAPACITY_RECALL_POSSIBLE("capacity_recall_possible", StatusMessageScope.ADMIN, 65, StatusMessageScope.NOBODY),
    MSG_CAPACITY_RECALL_NOT_POSSIBLE("capacity_recall_not_possible", StatusMessageScope.ADMIN, 66, StatusMessageScope.NOBODY),
    MSG_CAPACITY_RECALL_NOT_POSSIBLE_GTC("capacity_recall_not_possible_gtc", StatusMessageScope.ADMIN, 67, StatusMessageScope.NOBODY),
    MSG_SOB_CAPACITY_RECALL_NOT_POSSIBLE_PRIVATE("sob_capacity_recall_not_possible_private", StatusMessageScope.ADMIN, 261, StatusMessageScope.ADMIN),
    MSG_SOB_CAPACITY_RECALL_NOT_POSSIBLE_PUBLIC("sob_capacity_recall_not_possible_public", StatusMessageScope.ADMIN, 262, StatusMessageScope.ADMIN_PRODUCT),
    MSG_TRADE_PUBLIC("x_public_trade", StatusMessageScope.PUBLIC_PRODUCT, 70),
    MSG_TRADE_PUBLIC_PREARRANGED("x_public_trade_pre", StatusMessageScope.PUBLIC_PRODUCT, 71),
    MSG_TRADE_PUBLIC_RECALL_ACCEPTED("x_pub_recall_trade_acc", StatusMessageScope.PUBLIC_PRODUCT, 72),
    MSG_TRADE_PUBLIC_RECALL_REJECTED("x_pub_recall_trade_rej", StatusMessageScope.PUBLIC_PRODUCT, 73),
    MSG_CONTRACT_CLOSED("x_contract_closed", StatusMessageScope.PUBLIC_PRODUCT, 74, StatusMessageScope.PUBLIC_PRODUCT, "lts_x_contract_closed"),
    MSG_CONTRACT_CLOSED_TSOS("x_contract_closed_tsos", StatusMessageScope.MARKET_AREA, 76, StatusMessageScope.PUBLIC_PRODUCT, "lts_x_contract_closed_tsos"),
    MSG_CONTRACT_IN_BALANCING_PHASE("x_contract_in_balancing_phase", StatusMessageScope.MARKET_AREA, 77),
    MSG_CONTRACT_MODIFIED("contract_modified", StatusMessageScope.MARKET_AREA, 78, StatusMessageScope.ADMIN),
    MSG_CONTRACT_MODIFIED_PRIVATE("x_contract_modified_private", StatusMessageScope.ADMIN_PRODUCT, 79, StatusMessageScope.NOBODY, null),
    MSG_CONTRACT_MODIFIED_WITHOUT_PHASES("contract_modified_without_phases", StatusMessageScope.MARKET_AREA, 80, StatusMessageScope.ADMIN),
    MSG_CONTRACT_MODIFIED_WITHOUT_PHASES_PRIVATE("contract_modified_without_phases_private", StatusMessageScope.ADMIN_PRODUCT, 81, StatusMessageScope.NOBODY),
    MSG_CONTRACT_MODIFICATION_CANCELLED("x_contract_modification_cancelled", StatusMessageScope.ADMIN_PRODUCT, 82, StatusMessageScope.NOBODY, null),
    MSG_CONTRACT_HIBERNATED("contract_hibernated", StatusMessageScope.MARKET_AREA, 83, StatusMessageScope.ADMIN),
    MSG_CONTRACT_ACTIVATED("contract_activated", StatusMessageScope.MARKET_AREA, 84, StatusMessageScope.ADMIN),
    MSG_CONTRACT_HIBERNATED_PRIVATE("x_contract_hibernated_private", StatusMessageScope.ADMIN_PRODUCT, 85, StatusMessageScope.NOBODY, null),
    MSG_CONTRACT_ACTIVATED_PRIVATE("x_contract_activated_private", StatusMessageScope.ADMIN_PRODUCT, 86, StatusMessageScope.NOBODY, null),
    MSG_NOTPROCESSED_DUE_NOCHANGES("x_notprocessed_due_notchanges", StatusMessageScope.ADMIN_PRODUCT, 87, StatusMessageScope.NOBODY, null),
    MSG_SUPERVISOR_GLOBAL("supervisor_message", StatusMessageScope.PUBLIC, 88, StatusMessageScope.ADMIN),
    MSG_SUPERVISOR_MA("supervisor_message", StatusMessageScope.MARKET_AREA, 89, StatusMessageScope.ADMIN),
    MSG_SUPERVISOR_PRIVATE("x_supervisor_message_private", StatusMessageScope.ADMIN, 90, StatusMessageScope.NOBODY, null),
    MSG_MARKET_HALT("market_halt", StatusMessageScope.PUBLIC, 91, StatusMessageScope.PUBLIC, "lts_market_halt"),
    MSG_MARKET_GO("market_go", StatusMessageScope.PUBLIC, 92, StatusMessageScope.PUBLIC, "lts_market_go"),
    MSG_MARKET_HALT_PRIVATE("x_market_halt_private", StatusMessageScope.ADMIN, 93, StatusMessageScope.NOBODY, null),
    MSG_MARKET_GO_PRIVATE("x_market_go_private", StatusMessageScope.ADMIN, 94, StatusMessageScope.NOBODY, null),
    MSG_TRADING_PROCEDURE_CANCELLED("x_trading_procedure_cancelled", StatusMessageScope.ADMIN, 95, StatusMessageScope.NOBODY, null),
    MSG_HALT_PROCEDURE_CANCELLED("x_halt_procedure_cancelled", StatusMessageScope.ADMIN, 96, StatusMessageScope.NOBODY, null),
    MSG_STATUS_ALREADY_TRADING("x_status_already_trading", StatusMessageScope.ADMIN, 97, StatusMessageScope.NOBODY, null),
    MSG_STATUS_ALREADY_HALT("x_status_already_halt", StatusMessageScope.ADMIN, 98, StatusMessageScope.NOBODY, null),
    MSG_TSO_GO("tso_go", StatusMessageScope.MARKET_AREA, 99, StatusMessageScope.PUBLIC, "lts_tso_go"),
    MSG_TSO_GO_PRIVATE("x_tso_go_private", StatusMessageScope.ADMIN, 100, StatusMessageScope.NOBODY),
    MSG_TSO_HALT("tso_halt", StatusMessageScope.MARKET_AREA, 101, StatusMessageScope.PUBLIC, "lts_tso_halt"),
    MSG_TSO_HALT_AS_SERVICE_STATE("tso_halt_as_service", StatusMessageScope.PUBLIC, 102, StatusMessageScope.PUBLIC, "lts_tso_halt_as_service"),
    MSG_TSO_HALT_PRIVATE("x_tso_halt_private", StatusMessageScope.ADMIN, 103, StatusMessageScope.NOBODY),
    MSG_TSO_ALREADY_IN_HALT("x_tso_already_halt_private", StatusMessageScope.ADMIN, 104, StatusMessageScope.NOBODY),
    MSG_TSO_ALREADY_IN_TRADING("x_tso_already_trading_private", StatusMessageScope.ADMIN, 105, StatusMessageScope.NOBODY),
    MARKET_AREA_ALREADY_IN_HALT("marketArea_already_in_halt", StatusMessageScope.ADMIN, 106, StatusMessageScope.NOBODY),
    MARKET_AREA_ALREADY_IN_TRADING("marketArea_already_in_trading", StatusMessageScope.ADMIN, 107, StatusMessageScope.NOBODY),
    MSG_MARKET_SPLIT_AREA_CREATED("marketsplit_area_created", StatusMessageScope.ADMIN, 108, StatusMessageScope.NOBODY),
    MSG_MARKET_SPLIT_PERFORMED("marketsplit_performed", StatusMessageScope.ADMIN, 109, StatusMessageScope.NOBODY),
    MSG_PRODUCT_UPDATED("msg_product_updated", StatusMessageScope.PUBLIC, 110, StatusMessageScope.PUBLIC),
    MSG_PRODUCT_RELOADED("msg_product_reloaded", StatusMessageScope.PUBLIC, 111, StatusMessageScope.PUBLIC),
    MSG_PRODUCT_UPDATED_PRIVATE("msg_product_updated", StatusMessageScope.ADMIN, 112),
    MSG_SUSPEND_PRIVATE("msg_suspend_private", StatusMessageScope.BALGRP, 113, StatusMessageScope.ADMIN, "lts_msg_suspend_private"),
    MSG_UNSUSPEND_PRIVATE("msg_unsuspend_private", StatusMessageScope.BALGRP, 114, StatusMessageScope.ADMIN, "lts_msg_unsuspend_private"),
    MSG_BG_SUSPEND_ADMIN("msg_bg_suspend_admin", StatusMessageScope.ADMIN, 115, StatusMessageScope.NOBODY),
    MSG_BG_UNSUSPEND_ADMIN("msg_bg_unsuspend_admin", StatusMessageScope.ADMIN, 116, StatusMessageScope.NOBODY),
    MSG_MEMBER_SUSPEND_ADMIN("msg_member_suspend_admin", StatusMessageScope.ADMIN, 117, StatusMessageScope.NOBODY),
    MSG_MEMBER_UNSUSPEND_ADMIN("msg_member_unsuspend_admin", StatusMessageScope.ADMIN, 118, StatusMessageScope.NOBODY),
    MSG_TEXT_ADMIN("text", StatusMessageScope.ADMIN, 120),
    MSG_COB_AUCTION_STARTED("cob_auction_started", StatusMessageScope.PUBLIC_PRODUCT, 121, StatusMessageScope.PUBLIC_PRODUCT),
    MSG_COB_AUCTION_FINISHED("cob_auction_finished", StatusMessageScope.PUBLIC_PRODUCT, 122, StatusMessageScope.PUBLIC_PRODUCT),
    MSG_COB_AUCTION_RESULTS("cob_auction_results", StatusMessageScope.PUBLIC_PRODUCT, 123, StatusMessageScope.PUBLIC_PRODUCT),
    MSG_STATUS_CAPACITY_ALREADY_DISABLED("x_status_capacity_already_disabled", StatusMessageScope.ADMIN, 124, StatusMessageScope.NOBODY, null),
    MSG_STATUS_CAPACITY_ALREADY_ENABLED("x_status_capacity_already_enabled", StatusMessageScope.ADMIN, 125, StatusMessageScope.NOBODY, null),
    MSG_STATUS_CAPACITY_BORDER_ALREADY_DISABLED("x_status_capacity_border_already_disabled", StatusMessageScope.ADMIN, 126, StatusMessageScope.NOBODY, null),
    MSG_STATUS_CAPACITY_BORDER_ALREADY_ENABLED("x_status_capacity_border_already_enabled", StatusMessageScope.ADMIN, 127, StatusMessageScope.NOBODY, null),
    MSG_STATUS_CAPACITY_DISABLED("x_status_capacity_disabled", StatusMessageScope.ADMIN, 128, StatusMessageScope.NOBODY, null),
    MSG_STATUS_CAPACITY_ENABLED("x_status_capacity_enabled", StatusMessageScope.ADMIN, 129, StatusMessageScope.NOBODY, null),
    MSG_STATUS_CAPACITY_BORDER_DISABLED("x_status_capacity_border_disabled", StatusMessageScope.ADMIN, 130, StatusMessageScope.NOBODY, null),
    MSG_STATUS_CAPACITY_BORDER_ENABLED("x_status_capacity_border_enabled", StatusMessageScope.ADMIN, 131, StatusMessageScope.NOBODY, null),
    MSG_NO_CAPACITY_CONNECTION("capacity_disconnected", StatusMessageScope.ADMIN, 132, StatusMessageScope.NOBODY, null),
    MSG_TRADE_CANCELLED_PRIVATE_TRADER("trade_cancelled_private_trader", StatusMessageScope.BALGRP_PRODUCT, 133),
    MSG_TRADE_CANCELLED_PRIVATE_ADMIN("trade_cancelled_private_admin", StatusMessageScope.ADMIN_PRODUCT, 134),
    MSG_TRADE_CANCELLED_PUBLIC("trade_cancelled_public", StatusMessageScope.PUBLIC_PRODUCT, 135),
    MSG_LOGOUT_ACTION_TAKE_NO_ACTION("logout_action_no_action", StatusMessageScope.BALGRP, 136),
    MSG_LOGOUT_ACTION_DEACTIVATE_MY_ORDERS("logout_action_deactivate_myorders", StatusMessageScope.BALGRP, 137),
    MSG_LOGOUT_ACTION_DEACTIVATE_BG_ORDERS("logout_action_deactivate_bgorders", StatusMessageScope.BALGRP, 138),
    MSG_CONN_LOSS_TAKE_NO_ACTION("connection_loss_no_action", StatusMessageScope.BALGRP, 139, StatusMessageScope.ADMIN, "lts_connection_loss_no_action"),
    MSG_CONN_LOSS_DEACTIVATE_MY_ORDERS("connection_loss_deactivate_myorders", StatusMessageScope.BALGRP, 140, StatusMessageScope.ADMIN, "lts_connection_loss_deactivate_myorders"),
    MSG_CONN_LOSS_DEACTIVATE_BG_ORDERS("connection_loss_deactivate_bgorders", StatusMessageScope.BALGRP, 141, StatusMessageScope.ADMIN, "lts_connection_loss_deactivate_bgorders"),
    MSG_CONN_LOSS_ADMIN("connection_loss_admin", StatusMessageScope.BALGRP, 142, StatusMessageScope.ADMIN, "lts_connection_loss_admin"),
    MSG_QUOTE_REQUEST_FOR_MA("quote_request", StatusMessageScope.MARKET_AREA, 143),
    MSG_NO_SOB_CONNECTION("sob_disconnected", StatusMessageScope.ADMIN, 144),
    MSG_ORDER_TRIGGERED("order_triggered", StatusMessageScope.BALGRP_PRODUCT, 145, StatusMessageScope.NOBODY, null),
    FAILOVER_EVENT("failover_event", StatusMessageScope.PUBLIC, 146, StatusMessageScope.ADMIN, "lts_failover_event"),
    MSG_CONTRACT_REFERENCE_PRICE_CHANGED("x_contract_closing_price_changed", StatusMessageScope.PUBLIC_PRODUCT, 147),
    MSG_AUCTION_FINISHED("auction_finished", StatusMessageScope.PUBLIC_PRODUCT, 148),
    MSG_AUCTION_FINISHED_NO_TRADE("auction_finished_no_trade", StatusMessageScope.PUBLIC_PRODUCT, 149),
    MSG_CROSS_PRODUCT_SPREAD_CREATED("cross_product_spread_created", StatusMessageScope.PUBLIC, 150),
    MSG_ORDER_DELETED_CA_INACTIVATED("x_order_deleted_ca_inactivated", StatusMessageScope.BALGRP_PRODUCT, 151),
    MSG_ORDER_MODIFIED_CA_INACTIVATED("x_order_modified_ca_inactivated", StatusMessageScope.BALGRP_PRODUCT, 152),
    MSG_STOP_ORDER_CONVERTED("stop_order_converted", StatusMessageScope.BALGRP_PRODUCT, 153),
    MSG_TIMEZONE_SETUP_DIFFERS("timezone_setup_differs", StatusMessageScope.ADMIN, 154),
    MSG_CASH_LIMIT_BREACHED_MEMBER("cash_limit_breached_member", StatusMessageScope.MEMBER, 158),
    MSG_CASH_LIMIT_BREACHED_ADMIN("cash_limit_breached_admin", StatusMessageScope.ADMIN, 159),
    MSG_ECC_SUSPENDED_MEMBER_ACTIVATION("msg_ecc_suspended_member_activation", StatusMessageScope.ADMIN, 160),
    MSG_MISSING_HALF_TRADE_FOR_LOCAL_REMOTE_TRADE("missing_half_trade_for_local_remote_trade", StatusMessageScope.ADMIN, 161),
    MSG_ECC_MEMBER_SUSPENDED_ADMIN("msg_ecc_member_suspended_admin", StatusMessageScope.ADMIN, 162),
    MSG_CASH_LIMIT_BREACH_PREVENTED_DURING_AOT("cash_limit_breach_prevented_during_aot", StatusMessageScope.MEMBER, 163),
    MSG_AOT_INCOMPLETE_INACTIVE_CONTRACT_FOR_DA("aot_incomplete_inactive_contract_for_da", StatusMessageScope.BALGRP_PRODUCT, 164),
    MSG_RECEIVED_TRADE_WITH_UNKNOWN_ORDER("msg_received_trade_with_unknown_order", StatusMessageScope.ADMIN, 165, StatusMessageScope.NOBODY, null),
    MSG_THROTTLING_STATUS_CHANGED_NO_RESTRICTION_MEMBER("throttling_status_changed_no_restriction_member", StatusMessageScope.MEMBER, 166),
    MSG_THROTTLING_STATUS_CHANGED_NO_RESTRICTION_ADMIN("throttling_status_changed_no_restriction_admin", StatusMessageScope.ADMIN, 167),
    MSG_THROTTLING_STATUS_CHANGED_OTHER_STATUSES_MEMBER("throttling_status_changed_other_statuses_member", StatusMessageScope.MEMBER, 168),
    MSG_THROTTLING_STATUS_CHANGED_OTHER_STATUSES_ADMIN("throttling_status_changed_other_statuses_admin", StatusMessageScope.ADMIN, 169),
    MSG_THROTTLING_PROTECTIVE_SUSPENSION("throttling_protective_suspension", StatusMessageScope.ADMIN, 170),
    MSG_CONTRACT_GENERATION_FAILED_FOR_PRODUCT("contract_generation_failed_for_product", StatusMessageScope.ADMIN, 171);

    private static final Map<String, StatusMessageType> KEY_MAP;
    private static final Map<Integer, StatusMessageType> CODE_MAP;
    private final String key;
    private final int messageCode;
    private final StatusMessageScope scope;
    private final String forwardKey;
    private final StatusMessageScope forwardScope;

    private StatusMessageType(String key, StatusMessageScope scope, int messageCode) {
        this(key, scope, messageCode, null, null);
    }

    private StatusMessageType(String key, StatusMessageScope scope, int messageCode, StatusMessageScope forwardScope) {
        this(key, scope, messageCode, forwardScope, null);
    }

    private StatusMessageType(String key, StatusMessageScope scope, int messageCode, StatusMessageScope forwardScope, String forwardKey) {
        this.key = key;
        this.messageCode = messageCode;
        this.scope = scope;
        this.forwardKey = forwardKey;
        this.forwardScope = forwardScope;
    }

    public static StatusMessageType getType(int code) {
        return CODE_MAP.getOrDefault(code, MSG_UNKNOWN);
    }

    public static StatusMessageType getType(String key) {
        return KEY_MAP.getOrDefault(key, MSG_UNKNOWN);
    }

    public String getKey() {
        return this.key;
    }

    public int getMessageCode() {
        return this.messageCode;
    }

    public StatusMessageScope getScope() {
        return this.scope;
    }

    public String getForwardKey() {
        return this.forwardKey;
    }

    public StatusMessageScope getForwardScope() {
        return this.forwardScope;
    }

    public String toString() {
        return this.key;
    }

    static {
        KEY_MAP = new HashMap<String, StatusMessageType>(StatusMessageType.values().length + 1, 1.0f);
        CODE_MAP = new HashMap<Integer, StatusMessageType>(StatusMessageType.values().length + 1, 1.0f);
        for (StatusMessageType type : StatusMessageType.values()) {
            KEY_MAP.put(type.getKey(), type);
            CODE_MAP.put(type.getMessageCode(), type);
        }
    }
}

