/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.ui.jfx.util.control;

import com.deutscheboerse.ui.jfx.util.binding.DependentObservableValue;
import com.deutscheboerse.ui.jfx.util.control.PopupControlSkin;
import com.deutscheboerse.ui.jfx.util.control.PopupWidth;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Point2D;
import javafx.scene.Scene;
import javafx.scene.control.Control;
import javafx.scene.control.ListView;
import javafx.scene.control.PopupControl;
import javafx.scene.control.Skin;
import javafx.stage.Window;

public class ListViewPopup<T>
extends PopupControl {
    private final Control control;
    private final ListView<T> listView;
    private final ObjectProperty<PopupWidth> popupWidth;
    private final ObservableValue<Window> window;
    private final InvalidationListener repositionPopupListener;
    private final InvalidationListener weakRepositionPopupListener;

    public ListViewPopup(Control control, ListView<T> listView) {
        this.control = control;
        this.listView = listView;
        this.popupWidth = new SimpleObjectProperty<PopupWidth>(PopupWidth.USE_CONTROL_WIDTH);
        this.window = DependentObservableValue.get(this.sceneProperty(), Scene::windowProperty, new Observable[0]);
        this.window.addListener((observable2, oldWindow, newWindow) -> this.attachWindowPositionListener((Window)oldWindow, (Window)newWindow));
        this.repositionPopupListener = observable2 -> this.repositionPopup();
        this.weakRepositionPopupListener = new WeakInvalidationListener(this.repositionPopupListener);
        this.setAutoHide(true);
        this.setConsumeAutoHidingEvents(false);
        this.setAutoFix(false);
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new PopupControlSkin(this, this.listView);
    }

    private void repositionPopup() {
        if (this.isShowing() && this.control.getScene() != null && this.control.getScene().getWindow() != null) {
            double popupHeight;
            Window window = this.control.getScene().getWindow();
            Point2D lowerLeftConrnerOfControl = this.control.localToScreen(0.0, this.control.getHeight());
            double x = lowerLeftConrnerOfControl.getX();
            double y = lowerLeftConrnerOfControl.getY();
            double listPrefHeight = this.listView.prefHeight(this.listView.getPrefWidth());
            double listMaxHeight = this.listView.getMaxHeight();
            double d = popupHeight = listMaxHeight > 0.0 ? Math.min(listPrefHeight, listMaxHeight) : listPrefHeight;
            if (y + popupHeight > window.getY() + window.getHeight()) {
                y = y - this.control.getHeight() - popupHeight;
            }
            this.setX(x);
            this.setY(y);
        }
    }

    protected void showPopup() {
        this.show(this.control, this.getX(), this.getY());
        this.fixListViewWidth();
        this.repositionPopup();
    }

    private void fixListViewWidth() {
        double width = this.computePopupWidth();
        this.listView.setMinWidth(width);
        this.listView.setPrefWidth(width);
        this.listView.setMaxWidth(width);
    }

    private double computePopupWidth() {
        this.listView.requestLayout();
        double listViewPrefWidth = this.listView.prefWidth(-1.0);
        switch ((PopupWidth)((Object)this.popupWidth.get())) {
            case USE_CONTROL_WIDTH: {
                return Math.ceil(this.control.getWidth());
            }
            case USE_POPUP_CONTENT_WIDTH: {
                return Math.ceil(listViewPrefWidth);
            }
        }
        return Math.ceil(Math.max(this.control.getWidth(), listViewPrefWidth));
    }

    private void attachWindowPositionListener(Window oldWindow, Window newWindow) {
        if (oldWindow != null) {
            oldWindow.xProperty().removeListener(this.weakRepositionPopupListener);
            oldWindow.yProperty().removeListener(this.weakRepositionPopupListener);
        }
        if (newWindow != null) {
            newWindow.xProperty().addListener(this.weakRepositionPopupListener);
            newWindow.yProperty().addListener(this.weakRepositionPopupListener);
        }
    }

    public PopupWidth getPopupWidth() {
        return (PopupWidth)((Object)this.popupWidth.get());
    }

    public ObjectProperty<PopupWidth> popupWidthProperty() {
        return this.popupWidth;
    }

    public void setPopupWidth(PopupWidth popupWidth) {
        this.popupWidth.set(popupWidth);
    }
}

