/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.ui.jfx.util.control;

import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;

public class ListViewValueProperty<T>
extends ObjectPropertyBase<T> {
    private final ListView<T> listView;
    private final ListProperty<T> items;

    public ListViewValueProperty(ListView<T> listView) {
        this.listView = listView;
        this.listView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.listView.getSelectionModel().selectedIndexProperty().addListener(this::selectedIndexChanged);
        this.items = new SimpleListProperty<T>();
        this.items.bind(listView.itemsProperty());
        this.items.addListener(this::listedItemsChanged);
    }

    private void selectedIndexChanged(ObservableValue<? extends Number> observable2, Number oldValue, Number newValue) {
        int newIndex = newValue.intValue();
        ObservableList<T> items = this.listView.getItems();
        if (newIndex >= 0 && newIndex < items.size()) {
            this.setValue(items.get(newIndex));
        }
    }

    private void listedItemsChanged(ListChangeListener.Change<? extends T> c) {
        Object previouslySelected = this.getValue();
        ObservableList<T> items = this.listView.getItems();
        if (items.contains(previouslySelected)) {
            this.selectValue(previouslySelected);
        } else if (!items.isEmpty()) {
            this.listView.getSelectionModel().selectFirst();
        } else {
            this.listView.getSelectionModel().clearSelection();
        }
        super.set(this.listView.getSelectionModel().getSelectedItem());
    }

    @Override
    public void set(T newValue) {
        ObservableList<T> items = this.listView.getItems();
        if (newValue != null && !items.contains(newValue)) {
            if (!items.isEmpty()) {
                this.listView.getSelectionModel().selectFirst();
            } else {
                this.listView.getSelectionModel().clearSelection();
            }
        } else if (items.contains(newValue)) {
            this.selectValue(newValue);
        }
        super.set(this.listView.getSelectionModel().getSelectedItem());
    }

    private void selectValue(T newValue) {
        int index = this.listView.getItems().indexOf(newValue);
        if (index >= 0) {
            this.listView.getSelectionModel().select(index);
        }
    }

    @Override
    public Object getBean() {
        return this.listView;
    }

    @Override
    public String getName() {
        return "value";
    }
}

