/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.block.factory.primitive;

import org.eclipse.collections.api.block.function.primitive.CharToCharFunction;

public final class CharToCharFunctions {
    private static final CharToCharFunction TO_UPPERCASE = new ToUpperCaseCharToCharFunction();
    private static final CharToCharFunction TO_LOWERCASE = new ToLowerCaseCharToCharFunction();

    private CharToCharFunctions() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static CharToCharFunction toUpperCase() {
        return TO_UPPERCASE;
    }

    public static CharToCharFunction toLowerCase() {
        return TO_LOWERCASE;
    }

    private static class ToUpperCaseCharToCharFunction
    implements CharToCharFunction {
        private static final long serialVersionUID = 1L;

        private ToUpperCaseCharToCharFunction() {
        }

        @Override
        public char valueOf(char character) {
            return Character.toUpperCase(character);
        }
    }

    private static class ToLowerCaseCharToCharFunction
    implements CharToCharFunction {
        private static final long serialVersionUID = 1L;

        private ToLowerCaseCharToCharFunction() {
        }

        @Override
        public char valueOf(char character) {
            return Character.toLowerCase(character);
        }
    }
}

