/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.immutable.primitive;

import aQute.bnd.annotation.spi.ServiceProvider;
import java.util.stream.LongStream;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.factory.set.primitive.ImmutableLongSetFactory;
import org.eclipse.collections.api.set.primitive.ImmutableLongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableLongEmptySet;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableLongSingletonSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;

@ServiceProvider(value=ImmutableLongSetFactory.class)
public class ImmutableLongSetFactoryImpl
implements ImmutableLongSetFactory {
    public static final ImmutableLongSetFactory INSTANCE = new ImmutableLongSetFactoryImpl();

    @Override
    public ImmutableLongSet empty() {
        return ImmutableLongEmptySet.INSTANCE;
    }

    @Override
    public ImmutableLongSet of() {
        return this.empty();
    }

    @Override
    public ImmutableLongSet with() {
        return this.empty();
    }

    @Override
    public ImmutableLongSet of(long one) {
        return this.with(one);
    }

    @Override
    public ImmutableLongSet with(long one) {
        return new ImmutableLongSingletonSet(one);
    }

    @Override
    public ImmutableLongSet of(long ... items) {
        return this.with(items);
    }

    @Override
    public ImmutableLongSet with(long ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return LongHashSet.newSetWith(items).toImmutable();
    }

    @Override
    public ImmutableLongSet ofAll(LongIterable items) {
        return this.withAll(items);
    }

    @Override
    public ImmutableLongSet withAll(LongIterable items) {
        if (items instanceof ImmutableLongSet) {
            return (ImmutableLongSet)items;
        }
        return this.with(items.toArray());
    }

    @Override
    public ImmutableLongSet ofAll(Iterable<Long> iterable) {
        return this.withAll(iterable);
    }

    @Override
    public ImmutableLongSet withAll(Iterable<Long> iterable) {
        return LongSets.mutable.withAll(iterable).toImmutable();
    }

    @Override
    public ImmutableLongSet ofAll(LongStream items) {
        return this.withAll(items);
    }

    @Override
    public ImmutableLongSet withAll(LongStream items) {
        MutableLongSet newSet = LongSets.mutable.empty();
        items.forEach(newSet::add);
        return newSet.toImmutable();
    }
}

