/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper;

import com.deutscheboerse.comxerv.comtrader.api.m7.v6.hint.HubToHubHint;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModel;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.entities.AtcId;
import com.deutscheboerse.comxerv.comtrader.entities.H2HArea;
import com.deutscheboerse.comxerv.comtrader.entities.HubToHub;
import com.deutscheboerse.comxerv.comtrader.service.mapper.AbstractMapper;
import com.deutscheboerse.comxerv.comtrader.service.mapper.MapperHandler;
import com.deutscheboerse.comxerv.comtrader.util.DateTimeUtils;
import com.deutscheboerse.m7.trading.api.v6.HubToHubAtcType;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;

public class HubToHubMapper
extends AbstractMapper<HubToHubAtcType, HubToHub> {
    private final DataModel<String, H2HArea> h2HDataModel;

    public HubToHubMapper(ApplicationContext applicationContext, Exchange exchange) {
        super(applicationContext, exchange, HubToHubAtcType.class, HubToHub.class);
        this.h2HDataModel = applicationContext.getSmallDataModel(H2HArea.class);
    }

    @Override
    public HubToHub translate(HubToHubAtcType from, MapperHandler mapperHandler, Object hint) {
        if (!(hint instanceof HubToHubHint)) {
            throw new IllegalStateException("HubToHubHint expected");
        }
        HubToHubHint hubToHubHint = (HubToHubHint)hint;
        if (this.h2HDataModel.findById(from.getTo()) == null || this.h2HDataModel.findById(hubToHubHint.getFromMA()) == null) {
            return null;
        }
        DateTimeZone timeZone = this.getExchange().getSystemInfo().getTimeZone();
        Interval interval = DateTimeUtils.mapDatesToInterval(hubToHubHint.getDlvryStart(), hubToHubHint.getDlvryEnd(), timeZone);
        HubToHub hubToHub = new HubToHub();
        hubToHub.setTimestamp(DateTimeUtils.mapDateToDateTime(hubToHubHint.getTimestmp(), timeZone));
        if (hubToHubHint.getAtcDirection() == HubToHubHint.AtcDirection.OUT) {
            hubToHub.setId(new AtcId(interval, hubToHubHint.getFromMA(), from.getTo()));
            hubToHub.setAtc(from.getOut());
        } else {
            hubToHub.setId(new AtcId(interval, from.getTo(), hubToHubHint.getFromMA()));
            hubToHub.setAtc(from.getIn());
        }
        return hubToHub;
    }
}

