/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper;

import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.AbstractOrderMapper;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.EnumMapper;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderType;
import com.deutscheboerse.comxerv.comtrader.service.mapper.MapperHandler;
import com.deutscheboerse.comxerv.comtrader.util.DateTimeUtils;
import com.deutscheboerse.m7.trading.api.v6.OrderEntryStateType;
import com.deutscheboerse.m7.trading.api.v6.OrdrEntryType;
import com.deutscheboerse.m7.trading.api.v6.OrdrExeRestrictionType;
import org.apache.commons.lang3.StringUtils;

public class OrderEntryTypeMapper
extends AbstractOrderMapper<Order, OrdrEntryType> {
    public OrderEntryTypeMapper(ApplicationContext applicationContext, Exchange exchange) {
        super(applicationContext, exchange, Order.class, OrdrEntryType.class);
    }

    @Override
    public OrdrEntryType translate(Order from, MapperHandler mapperHandler, Object hint) {
        Product product = from.getContract().getProduct();
        OrdrEntryType orderEntry = new OrdrEntryType();
        if (from.getContractId() == null) {
            orderEntry.setProd(from.getContract().getProduct().getName());
            orderEntry.setDlvryStart(DateTimeUtils.mapDateTimeToDate(from.getContract().getDeliveryStart()));
            orderEntry.setDlvryEnd(DateTimeUtils.mapDateTimeToDate(from.getContract().getDeliveryEnd()));
        } else {
            orderEntry.setContractId(from.getContractId());
        }
        orderEntry.setDisplayQty(product.mapQuantityToBackend(from.getPeakQuantity()));
        orderEntry.setPpd(product.mapPriceToBackend(from.getPeakPriceDelta()));
        if (from.getLimitPrice() != null) {
            orderEntry.setPx(product.mapPriceToBackend(from.getLimitPrice()));
        }
        if (from.getStopPrice() != null) {
            orderEntry.setStopPx(product.mapPriceToBackend(from.getStopPrice()));
        }
        if (from.getRemainingQuantity() != null) {
            orderEntry.setQty(product.mapQuantityToBackend(from.getRemainingQuantity()));
        }
        if (from.getExecutionRestriction() != null) {
            orderEntry.setOrdrExeRestriction(this.mapExecutionRestriction(from.getExecutionRestriction()));
        } else {
            orderEntry.setOrdrExeRestriction(OrdrExeRestrictionType.NON);
        }
        orderEntry.setType(this.mapOrderType(from.getOrderType(), from.getContract()));
        if (OrderType.OTC_PREARRANGED.equals(from.getOrderType())) {
            orderEntry.setPreArranged(true);
            orderEntry.setPreArrangedAcct(from.getPreArrangedBalancingGroupId());
        }
        if (from.getText() != null) {
            orderEntry.setTxt(from.getText());
        }
        if (StringUtils.isNotEmpty(from.getLocation())) {
            orderEntry.setLocation(from.getLocation());
        }
        if (from.isMarketBased() != null) {
            orderEntry.setMarketBased(from.isMarketBased());
        }
        if (StringUtils.isNotEmpty(from.getContractReference())) {
            orderEntry.setContractReference(from.getContractReference());
        }
        if (StringUtils.isNotEmpty(from.getFacilityType())) {
            orderEntry.setFacilityType(from.getFacilityType());
        }
        if (from.getUsageFraction() != null) {
            orderEntry.setUsageFraction(from.getUsageFraction());
        }
        orderEntry.setClearingAcctType(from.getAccount());
        orderEntry.setAcctId(from.getBalancingGroupId());
        orderEntry.setDlvryAreaId(from.getDeliveryAreaId());
        orderEntry.setSide(EnumMapper.mapDirection(from.getDirection()));
        switch (from.getStatus()) {
            case ACTIVE: 
            case ERROR: {
                orderEntry.setState(OrderEntryStateType.ACTI);
                break;
            }
            case HIBERNATE: {
                orderEntry.setState(OrderEntryStateType.HIBE);
                break;
            }
            default: {
                throw new IllegalStateException(from.getStatus().toString());
            }
        }
        orderEntry.setValidityDate(DateTimeUtils.mapDateTimeToDate(from.getValidityDate()));
        orderEntry.setValidityRes(this.mapValidityRestriction(from.getValidityRestriction()));
        orderEntry.setProd(from.getContract().getProduct().getName());
        orderEntry.setClOrdrId(from.getClientOrderId());
        if (from.getOpenOrClose() != null) {
            orderEntry.setOpenCloseInd(this.mapOpenCloseIndicator(from.getOpenOrClose()));
        }
        orderEntry.setAot(Boolean.TRUE.equals(from.getAot()));
        return orderEntry;
    }
}

