/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper;

import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.UserMapper;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModel;
import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.entities.Member;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.entities.UserRoles;
import com.deutscheboerse.m7.trading.api.v6.UserRprt;

public abstract class UserRprtMapper<U extends User>
extends UserMapper<UserRprt, U> {
    private final DataModel<String, Member> memberDataModel;

    public UserRprtMapper(ApplicationContext applicationContext, Exchange exchange, Class<U> to) {
        super(applicationContext, exchange, UserRprt.class, to);
        this.memberDataModel = applicationContext.getDataModel(Member.class);
    }

    protected void translateUserRprt(UserRprt from, U to) {
        UserRprt.Usr user = from.getUsr();
        ((BroadcastEntity)to).setId(user.getUsrId());
        ((User)to).setRevisionNumber(user.getRevisionNo());
        ((User)to).setRoles(new UserRoles.SimpleRoleSet(user.getUsrRole()));
        this.mapBasicUser(user, (User)to);
        Member member = this.memberDataModel.findById(user.getMbrId());
        if (member == null) {
            member = ((User)to).getMember() != null ? ((User)to).getMember() : new Member();
            member.setId(user.getMbrId());
        }
        ((User)to).setMember(member);
        ((User)to).getMember().setName(user.getMbrName());
    }
}

