/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.datamodel;

import com.deutscheboerse.comxerv.comtrader.core.ActiveExchange;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.datamodel.SmallFastDataModelBase;
import com.deutscheboerse.comxerv.comtrader.entities.BlockContract;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.FullTrade;
import com.deutscheboerse.comxerv.comtrader.service.event.EntityAdditionalLoadingFinishedEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.LoadingStartedEvent;
import com.deutscheboerse.comxerv.comtrader.service.time.TimeService;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.joda.time.DateTime;

public class ContractDataModel
extends SmallFastDataModelBase<Long, Contract> {
    private volatile boolean additionalLoadingFinished;

    public ContractDataModel(ApplicationContext applicationContext) {
        super(applicationContext);
        this.appContext.getService(EventBus.class).register(this);
    }

    @Override
    public Class<Contract> getEntityClass() {
        return Contract.class;
    }

    @Subscribe
    public void handleLoadingStartedEvent(LoadingStartedEvent event) {
        this.additionalLoadingFinished = false;
    }

    @Subscribe
    public void handleAdditionalLoadingFinishedEvent(EntityAdditionalLoadingFinishedEvent<FullTrade> event) {
        if (FullTrade.class.equals(event.getEntityClass())) {
            this.additionalLoadingFinished = true;
        }
    }

    @Override
    public Contract add(Contract contract) {
        Contract oldContract = (Contract)this.findById((Long)contract.getId());
        if (oldContract != null) {
            oldContract.merge(contract);
            DateTime serverTime = this.appContext.getService(TimeService.class).getServerTime();
            oldContract.setBetweenTradingAndDeliveryEnd(contract.computeBetweenTradingAndDeliveryEnd(serverTime));
            return oldContract;
        }
        return super.add(contract);
    }

    private boolean isContractExpired(DateTime serverTime, Exchange exchange, Contract contract) {
        return contract.getDeliveryEnd().isBefore(serverTime.minusDays(exchange.getSystemInfo().getContractStoreTimeInDays()).minusMinutes(70));
    }

    @Override
    public void runCleanup() {
        if (!this.additionalLoadingFinished) {
            return;
        }
        DateTime serverTime = this.appContext.getService(TimeService.class).getServerTime();
        Exchange exchange = this.appContext.getService(ActiveExchange.class).getActiveExchange().get();
        if (exchange != null) {
            this.removeIf(contract -> contract instanceof BlockContract && this.isContractExpired(serverTime, exchange, (Contract)contract));
            Set underlyingContracts = this.getAllEntitiesAsStream().filter(BlockContract.class::isInstance).flatMap(contract -> ((BlockContract)contract).getUnderlyingContracts().stream()).map(BroadcastEntity::getId).collect(Collectors.toSet());
            this.removeIf(contract -> this.isContractExpired(serverTime, exchange, (Contract)contract) && !underlyingContracts.contains(contract.getId()));
        }
    }

    protected void updateStati() {
        DateTime serverTime = this.appContext.getService(TimeService.class).getServerTime();
        this.updateStati(serverTime);
    }

    private void updateStati(DateTime dateTime) {
        List<Contract> becomesInBetweenTradingAndDelivery = this.getAllEntitiesAsStream().filter(contract -> !contract.isBetweenTradingAndDeliveryEnd()).filter(contract -> contract.computeBetweenTradingAndDeliveryEnd(dateTime)).toList();
        this.updateBetweenTradingAndDelivery(becomesInBetweenTradingAndDelivery, true);
        List<Contract> noLongerInBetweenTradingAndDelivery = this.getAllEntitiesAsStream().filter(Contract::isBetweenTradingAndDeliveryEnd).filter(contract -> !contract.computeBetweenTradingAndDeliveryEnd(dateTime)).toList();
        this.updateBetweenTradingAndDelivery(noLongerInBetweenTradingAndDelivery, false);
    }

    private void updateBetweenTradingAndDelivery(List<Contract> contracts, boolean betweenTradingAndDeliveryEnd) {
        contracts.forEach(contract -> {
            this.notifyUpdateListeners(contract, this.preListeners);
            contract.setBetweenTradingAndDeliveryEnd(betweenTradingAndDeliveryEnd);
            this.notifyUpdateListeners(contract, this.postListeners);
        });
    }
}

