/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.datamodel.query;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataQuery;
import com.deutscheboerse.comxerv.comtrader.datamodel.FullTradeDataModel;
import com.deutscheboerse.comxerv.comtrader.datamodel.mapdb.Pair;
import com.deutscheboerse.comxerv.comtrader.datamodel.query.LargeDataModelQuery;
import com.deutscheboerse.comxerv.comtrader.datamodel.query.LargeDataModelRangeQuery;
import com.deutscheboerse.comxerv.comtrader.domain.query.FullTradeQueries;
import com.deutscheboerse.comxerv.comtrader.entities.FullTrade;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.NavigableSet;
import org.joda.time.DateTime;

@Singleton
class FullTradeQueriesImpl
implements FullTradeQueries {
    private final FullTradeDataModel fullTradeDataModel;

    @Inject
    public FullTradeQueriesImpl(ApplicationContext applicationContext) {
        this.fullTradeDataModel = (FullTradeDataModel)applicationContext.getLargeDataModel(FullTrade.class);
    }

    @Override
    public DataQuery<FullTrade> findByTradingDate(DateTime day) {
        return this.getDayQuery(day, this.fullTradeDataModel.getTradeDateIndex(), true, false);
    }

    @Override
    public DataQuery<FullTrade> findByDeliveryDate(DateTime day) {
        return this.getDayQuery(day, this.fullTradeDataModel.getDeliveryDateIndex(), false, true);
    }

    @Override
    public DataQuery<FullTrade> findByParentTradeId(Long parentTradeId) {
        return new LargeDataModelQuery<Long, FullTrade, Long>(this.fullTradeDataModel::findById, this.fullTradeDataModel.getParentTradeIdIndex(), parentTradeId);
    }

    private LargeDataModelRangeQuery<Long, FullTrade, Long> getDayQuery(DateTime day, NavigableSet<Pair<Long, Long>> index, boolean lowInclusive, boolean distinct2) {
        LargeDataModelRangeQuery.Interval<Long> interval = LargeDataModelRangeQuery.Interval.of(day.withTimeAtStartOfDay().getMillis(), lowInclusive, day.withTimeAtStartOfDay().plusDays(1).getMillis(), false);
        return new LargeDataModelRangeQuery<Long, FullTrade, Long>(this.fullTradeDataModel::findById, index, interval, distinct2);
    }
}

