/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.datamodel.query;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataQuery;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.SmallFastDataModel;
import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.core.entity.EntityFilters;
import com.deutscheboerse.comxerv.comtrader.datamodel.query.DataStreamQuery;
import com.deutscheboerse.comxerv.comtrader.datamodel.query.SortedSmallFastDataModelQuery;
import com.deutscheboerse.comxerv.comtrader.domain.query.MemberQueries;
import com.deutscheboerse.comxerv.comtrader.entities.Member;
import com.deutscheboerse.comxerv.comtrader.entities.type.SuspensionType;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

@Singleton
class MemberQueriesImpl
implements MemberQueries {
    private final SmallFastDataModel<String, Member> dataModel;

    @Inject
    public MemberQueriesImpl(ApplicationContext applicationContext) {
        this.dataModel = applicationContext.getSmallDataModel(Member.class);
    }

    @Override
    public DataQuery<Member> findActiveMembersByIdBeginning(String idPrefix) {
        return new SortedSmallFastDataModelQuery<String, Member>(this.dataModel, Member::compareTo).addFilter(EntityFilters.propertyEquals(Member::getSuspensionType, SuspensionType.ACTIVE)).addFilter(EntityFilters.startsWith(BroadcastEntity::getId, idPrefix));
    }

    @Override
    public DataQuery<Member> findActiveMembersByIds(Set<String> memberIds) {
        Supplier membersByIds = () -> memberIds.stream().map(this.dataModel::findById).filter(Objects::nonNull);
        return new DataStreamQuery<Member>(membersByIds).addFilter(EntityFilters.propertyEquals(Member::getSuspensionType, SuspensionType.ACTIVE));
    }
}

