/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.datamodel.query;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.SmallFastDataModel;
import com.deutscheboerse.comxerv.comtrader.domain.query.MessageQueries;
import com.deutscheboerse.comxerv.comtrader.entities.Message;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.TreeSet;
import java.util.stream.Stream;

@Singleton
public class MessageQueriesImpl
implements MessageQueries {
    private final SmallFastDataModel<String, Message> messageDataModel;
    private final TreeSet<Message> messagesSortedByTimestamp = new TreeSet((o1, o2) -> o1.getTimeStamp().compareTo(o2.getTimeStamp()));

    @Inject
    public MessageQueriesImpl(ApplicationContext applicationContext) {
        this.messageDataModel = applicationContext.getSmallDataModel(Message.class);
        this.messageDataModel.registerListener(new DataModelListener<Message>(){

            @Override
            public DataModelListener.NotificationResult notifyAdd(Message object) {
                MessageQueriesImpl.this.messagesSortedByTimestamp.add(object);
                return DataModelListener.NotificationResult.RETAIN_LISTENER;
            }

            @Override
            public DataModelListener.NotificationResult notifyAddAll(Collection<Message> objects) {
                MessageQueriesImpl.this.messagesSortedByTimestamp.addAll(objects);
                return DataModelListener.NotificationResult.RETAIN_LISTENER;
            }

            @Override
            public DataModelListener.NotificationResult notifyRemove(Message object) {
                MessageQueriesImpl.this.messagesSortedByTimestamp.remove(object);
                return DataModelListener.NotificationResult.RETAIN_LISTENER;
            }

            @Override
            public DataModelListener.NotificationResult notifyRemoveAll(Collection<Message> objects) {
                MessageQueriesImpl.this.messagesSortedByTimestamp.removeAll(objects);
                return DataModelListener.NotificationResult.RETAIN_LISTENER;
            }

            @Override
            public DataModelListener.NotificationResult notifyRemoveAll() {
                MessageQueriesImpl.this.messagesSortedByTimestamp.clear();
                return DataModelListener.NotificationResult.RETAIN_LISTENER;
            }

            @Override
            public DataModelListener.NotificationResult notifyUpdate(Message object) {
                MessageQueriesImpl.this.messagesSortedByTimestamp.add(object);
                return DataModelListener.NotificationResult.RETAIN_LISTENER;
            }

            @Override
            public DataModelListener.NotificationResult notifyUpdateAll(Collection<Message> objects) {
                MessageQueriesImpl.this.messagesSortedByTimestamp.addAll(objects);
                return DataModelListener.NotificationResult.RETAIN_LISTENER;
            }
        });
    }

    @Override
    public Stream<Message> getAllSortedByTimestamp() {
        return this.messagesSortedByTimestamp.stream();
    }
}

