/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.entities;

import com.deutscheboerse.comxerv.comtrader.core.util.DisplayName;
import com.deutscheboerse.comxerv.comtrader.entities.DateInterval;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import java.io.Serializable;
import java.util.Objects;
import org.joda.time.DateTime;

public class DateFilterChoice
implements DateInterval,
DisplayName,
Serializable {
    private static final long serialVersionUID = 4979230973982125526L;
    public static final DateFilterChoice TODAY = new DateFilterChoice(Util.getLabel("commons_inRangeOperatorToday"), 0);
    public static final DateFilterChoice TOMORROW = new DateFilterChoice(Util.getLabel("commons_inRangeOperatorTomorrow"), 1);
    private final String label;
    private final int offsetInDays;

    public DateFilterChoice(String label, int offsetInDays) {
        this.label = label;
        this.offsetInDays = offsetInDays;
    }

    @Override
    public DateTime getStartTime(DateTime now) {
        return now.plusDays(this.offsetInDays).withTime(0, 0, 0, 0);
    }

    @Override
    public DateTime getEndTime(DateTime now) {
        return now.plusDays(this.offsetInDays).withTime(23, 59, 59, 999);
    }

    public int getOffsetInDays() {
        return this.offsetInDays;
    }

    @Override
    public String getDisplayName() {
        return this.label;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateFilterChoice that = (DateFilterChoice)o;
        return this.offsetInDays == that.offsetInDays;
    }

    public int hashCode() {
        return Objects.hash(this.offsetInDays);
    }
}

