/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.entities;

import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.core.entity.SmallDataModelEntity;
import com.deutscheboerse.comxerv.comtrader.core.util.DisplayName;
import com.deutscheboerse.comxerv.comtrader.entities.Member;
import com.deutscheboerse.comxerv.comtrader.entities.Mergeable;
import com.deutscheboerse.comxerv.comtrader.entities.RevisionNumbered;
import com.deutscheboerse.comxerv.comtrader.entities.UserRoles;
import com.deutscheboerse.comxerv.comtrader.entities.type.SuspensionType;
import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class User
extends BroadcastEntity<Integer>
implements RevisionNumbered,
Comparable<User>,
Mergeable<User>,
SmallDataModelEntity,
DisplayName {
    private final LongProperty revisionNumber;
    private final StringProperty userCode;
    private final StringProperty name;
    private final StringProperty memberId;
    private final ObjectProperty<Member> member;
    private final StringProperty defaultBalancingGroup = new SimpleStringProperty();
    private final ObjectProperty<SuspensionType> suspensionType;
    private UserRoles roles;
    private Set<String> balancingGroupIds;
    private final ObservableValue<String> displayName;
    private final Exchange exchange;

    public User(Exchange exchange) {
        this.memberId = new SimpleStringProperty();
        this.userCode = new SimpleStringProperty();
        this.name = new SimpleStringProperty();
        this.revisionNumber = new SimpleLongProperty();
        this.member = new SimpleObjectProperty<Member>();
        this.suspensionType = new SimpleObjectProperty<SuspensionType>();
        this.balancingGroupIds = Collections.emptySet();
        this.displayName = DependentBinding.get(this::computeDisplayName, this.userCode, this.name);
        this.exchange = exchange;
    }

    private String computeDisplayName() {
        String currentName = (String)this.name.get();
        boolean nameEmpty = currentName == null || currentName.isEmpty();
        return this.getUserCode() + (String)(!nameEmpty ? " (" + currentName + ")" : "");
    }

    public boolean hasPermissionsForTradeSettlements() {
        boolean isTrader = this.getRoles().isTrader() || this.getRoles().isBroker();
        boolean isSalesOrAdmin = this.getRoles().isAdmin() || this.getRoles().isSalesUser();
        return isSalesOrAdmin || isTrader && this.exchange.getSystemInfo().supportsSettlement();
    }

    public boolean hasPermissionsForTradeSettlementInfoForTrader() {
        boolean isTrader = this.getRoles().isTrader() || this.getRoles().isBroker();
        boolean isSalesOrAdmin = this.getRoles().isAdmin() || this.getRoles().isSalesUser();
        return isSalesOrAdmin || isTrader && this.exchange.getSystemInfo().supportsSettlementInfoForTrader();
    }

    @Override
    public String getDisplayName() {
        return this.displayName.getValue();
    }

    public ObservableValue<String> displayNameProperty() {
        return this.displayName;
    }

    public Set<String> getBalancingGroupIds() {
        return Collections.unmodifiableSet(this.balancingGroupIds);
    }

    public void setBalancingGroupIds(Collection<String> balancingGroupIds) {
        this.balancingGroupIds = balancingGroupIds == null ? Collections.emptySet() : new HashSet<String>(balancingGroupIds);
    }

    public boolean containsBalancingGroupId(String bgId) {
        return this.balancingGroupIds.contains(bgId);
    }

    @Override
    public void merge(User other) {
        this.setRevisionNumber(other.getRevisionNumber());
        this.setUserCode(other.getUserCode());
        this.setName(other.getName());
        this.setMemberId(other.getMemberId());
        this.setMember(other.getMember());
        this.setDefaultBalancingGroup(other.getDefaultBalancingGroup());
        this.setSuspensionType(other.getSuspensionType());
        this.setRoles(other.getRoles());
        this.setBalancingGroupIds(other.getBalancingGroupIds());
    }

    @Override
    public Class<User> getEntityClass() {
        return User.class;
    }

    public Exchange getExchange() {
        return this.exchange;
    }

    @Override
    public int compareTo(User o) {
        return ((Integer)this.getId()).compareTo((Integer)o.getId());
    }

    @Override
    public long getRevisionNumber() {
        return this.revisionNumber.get();
    }

    public LongProperty revisionNumberProperty() {
        return this.revisionNumber;
    }

    public void setRevisionNumber(long revisionNumber) {
        this.revisionNumber.set(revisionNumber);
    }

    public String getUserCode() {
        return (String)this.userCode.get();
    }

    public StringProperty userCodeProperty() {
        return this.userCode;
    }

    public void setUserCode(String userCode) {
        this.userCode.set(userCode);
    }

    public String getName() {
        return (String)this.name.get();
    }

    public StringProperty nameProperty() {
        return this.name;
    }

    public void setName(String name) {
        this.name.set(name);
    }

    public String getMemberId() {
        return (String)this.memberId.get();
    }

    public StringProperty memberIdProperty() {
        return this.memberId;
    }

    public void setMemberId(String memberId) {
        this.memberId.set(memberId);
    }

    public Member getMember() {
        return (Member)this.member.get();
    }

    public ObjectProperty<Member> memberProperty() {
        return this.member;
    }

    public void setMember(Member member) {
        this.member.set(member);
    }

    public String getDefaultBalancingGroup() {
        return (String)this.defaultBalancingGroup.get();
    }

    public StringProperty defaultBalancingGroupProperty() {
        return this.defaultBalancingGroup;
    }

    public void setDefaultBalancingGroup(String defaultBalancingGroup) {
        this.defaultBalancingGroup.set(defaultBalancingGroup);
    }

    public SuspensionType getSuspensionType() {
        return (SuspensionType)((Object)this.suspensionType.get());
    }

    public ObjectProperty<SuspensionType> suspensionTypeProperty() {
        return this.suspensionType;
    }

    public void setSuspensionType(SuspensionType suspensionType) {
        this.suspensionType.set(suspensionType);
    }

    public UserRoles getRoles() {
        return this.roles;
    }

    public void setRoles(UserRoles roles) {
        this.roles = roles;
    }

    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE).append("id", this.getId()).append("userCode", this.getUserCode()).append("memberId", this.getMemberId()).toString();
    }
}

