/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.entities.orderbook.listener;

import com.deutscheboerse.comxerv.comtrader.entities.orderbook.listener.BatchUpdateListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchUpdateListeners<T> {
    private static final Logger LOG = LoggerFactory.getLogger(BatchUpdateListeners.class);
    private final Collection<BatchUpdateListener<T>> listeners = new ConcurrentLinkedQueue<BatchUpdateListener<T>>();

    public void batchStarted() {
        Iterator<BatchUpdateListener<T>> iterator2 = this.listeners.iterator();
        while (iterator2.hasNext()) {
            BatchUpdateListener<T> listener = iterator2.next();
            try {
                if (listener.batchStarted() != BatchUpdateListener.NotificationResult.REMOVE_LISTENER) continue;
                iterator2.remove();
            }
            catch (RuntimeException e) {
                LOG.error("Error when calling a BatchUpdateListener", e);
            }
        }
    }

    public void batchFinished() {
        Iterator<BatchUpdateListener<T>> iterator2 = this.listeners.iterator();
        while (iterator2.hasNext()) {
            BatchUpdateListener<T> listener = iterator2.next();
            try {
                if (listener.batchFinished() != BatchUpdateListener.NotificationResult.REMOVE_LISTENER) continue;
                iterator2.remove();
            }
            catch (RuntimeException e) {
                LOG.error("Error when calling a BatchUpdateListener", e);
            }
        }
    }

    public void itemAdded(T item) {
        Iterator<BatchUpdateListener<T>> iterator2 = this.listeners.iterator();
        while (iterator2.hasNext()) {
            BatchUpdateListener<T> listener = iterator2.next();
            try {
                if (listener.itemAdded(item) != BatchUpdateListener.NotificationResult.REMOVE_LISTENER) continue;
                iterator2.remove();
            }
            catch (RuntimeException e) {
                LOG.error("Error when calling a BatchUpdateListener", e);
            }
        }
    }

    public void itemRemoved(T item) {
        Iterator<BatchUpdateListener<T>> iterator2 = this.listeners.iterator();
        while (iterator2.hasNext()) {
            BatchUpdateListener<T> listener = iterator2.next();
            try {
                if (listener.itemRemoved(item) != BatchUpdateListener.NotificationResult.REMOVE_LISTENER) continue;
                iterator2.remove();
            }
            catch (RuntimeException e) {
                LOG.error("Error when calling a BatchUpdateListener", e);
            }
        }
    }

    public void addListener(BatchUpdateListener<T> listener) {
        this.listeners.add(listener);
    }

    public void removeListener(BatchUpdateListener<T> listener) {
        this.listeners.remove(listener);
    }
}

