/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components;

import com.deutscheboerse.comxerv.comtrader.app.login.StorableComponent;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.domain.filter.ProductFilters;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.ContractAdditionOrigin;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookValueWrapper;
import com.deutscheboerse.comxerv.comtrader.jfx.components.AbstractOrderbookPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.bottomtoolbar.DeliverySortBottomToolbarChoiceBox;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.AbstractOrderbookPane;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.DetailedOrderbookPanelState;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.OrderbookRemovalCallback;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.OrderingType;
import com.deutscheboerse.comxerv.comtrader.jfx.service.csv.ImportExportService;
import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import com.deutscheboerse.ui.jfx.util.binding.MappedObservableList;
import com.deutscheboerse.ui.jfx.util.control.NoSelectionModel;
import com.deutscheboerse.ui.jfx.util.event.KeyEventUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.fxml.FXML;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TitledPane;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import org.joda.time.LocalDate;

public abstract class DetailedOrderbookPanel
extends AbstractOrderbookPanel<ExtendedOrderbook, DeliveryArea>
implements StorableComponent<DetailedOrderbookPanelState> {
    @FXML
    protected ListView<AbstractOrderbookPane> orderbookList;
    @FXML
    protected DeliverySortBottomToolbarChoiceBox deliverySortBottomToolbarChoiceBox;
    @FXML
    protected TitledPane menu;
    @FXML
    protected BorderPane listContainer;
    private final ImportExportService importExportService = this.getAppContext().getService(ImportExportService.class);
    private final ObjectProperty<Comparator<ExtendedOrderbook>> ordering;
    private final ObjectProperty<OrderingType> orderingType = new SimpleObjectProperty<OrderingType>(OrderingType.BY_NAME);
    private final ObservableList<AbstractOrderbookPane> sortedPanes;
    private final SortedList<ExtendedOrderbook> sortedFilteredOrderbooks;

    public DetailedOrderbookPanel(ApplicationContext applicationContext, Predicate<Contract> contractFilter) {
        this(applicationContext, contractFilter, ProductFilters.NON_OTC_NON_BLOCK_PRODUCTS_FILTER);
    }

    public DetailedOrderbookPanel(ApplicationContext applicationContext, Predicate<Contract> contractFilter, Predicate<Product> productFilter) {
        super(applicationContext, contractFilter, productFilter);
        this.ordering = new SimpleObjectProperty<Comparator<ExtendedOrderbook>>();
        this.ordering.bind((ObservableValue<Comparator<ExtendedOrderbook>>)new DependentBinding<Comparator<ExtendedOrderbook>>(new Observable[]{this.orderingType}){

            @Override
            protected Comparator<ExtendedOrderbook> computeValue() {
                OrderingType orderType = (OrderingType)DetailedOrderbookPanel.this.orderingType.get();
                switch (orderType) {
                    case BY_NAME: {
                        return new NameComparator(false);
                    }
                    case BY_DELIVERY_START: {
                        return new DeliveryStartComparator(false);
                    }
                    case BY_DELIVERY_END: {
                        return new DeliveryEndComparator(false);
                    }
                }
                throw new IllegalStateException(orderType.toString());
            }
        });
        this.sortedFilteredOrderbooks = new SortedList(this.filteredOrderbooks);
        this.sortedFilteredOrderbooks.comparatorProperty().bind(this.ordering);
        this.sortedPanes = MappedObservableList.get(this.sortedFilteredOrderbooks, ExtendedOrderbook::getOrderbookPane);
        this.addEventFilter(KeyEvent.KEY_PRESSED, (? super T keyEvent) -> {
            if (KeyEventUtil.isCtrlKeyCode(KeyCode.C, keyEvent)) {
                this.exportClipboard();
                keyEvent.consume();
            } else if (KeyEventUtil.isCtrlKeyCode(KeyCode.E, keyEvent)) {
                this.exportCSV();
                keyEvent.consume();
            }
        });
    }

    @Override
    public void initialize() {
        super.initialize();
        this.orderbookList.setSelectionModel(new NoSelectionModel());
        this.orderingType.bind(this.deliverySortBottomToolbarChoiceBox.valueProperty());
        this.listContainer.centerProperty().bind(Bindings.when(Bindings.isEmpty(this.filteredOrderbooks)).then(this.getEmptyOrderbookPanelPlaceholder()).otherwise(this.orderbookList));
        this.orderbookList.setOnMousePressed(mouseEvent -> this.minimizeContractPanel());
        this.orderbookList.setCellFactory(param -> new DetailedOrderbookListCell());
        Bindings.bindContent(this.orderbookList.getItems(), this.sortedPanes);
    }

    @FXML
    public void collapseAll() {
        for (ExtendedOrderbook orderbook : this.orderbooks) {
            orderbook.getOrderbookPane().collapse();
        }
    }

    @FXML
    public void expandAll() {
        for (ExtendedOrderbook orderbook : this.orderbooks) {
            orderbook.getOrderbookPane().expand();
        }
    }

    public void closeExtendedOrderbookPane(AbstractOrderbookPane pane) {
        this.orderbooks.removeIf(orderbookItem -> orderbookItem.getOrderbookPane() == pane);
        this.refilterOrderbooks();
    }

    @Override
    public DetailedOrderbookPanelState getComponentState() {
        return new DetailedOrderbookPanelState(this.getBasicState(), (OrderingType)this.orderingType.get(), this.menu.isExpanded());
    }

    @Override
    public void restoreComponentState(DetailedOrderbookPanelState componentState) {
        super.restoreComponentState(componentState.getOrderbookPanelState());
        this.deliverySortBottomToolbarChoiceBox.setValue(componentState.getOrderingType());
        this.menu.setExpanded(componentState.isMenuExpanded());
    }

    private static int compareComplex(ExtendedOrderbook o1, ExtendedOrderbook o2) {
        Contract contract1 = o1.getOrderbook().getContract();
        Contract contract2 = o2.getOrderbook().getContract();
        int deliveryPeriodComparison = contract2.getDeliveryDuration().compareTo(contract1.getDeliveryDuration());
        if (deliveryPeriodComparison == 0) {
            int contractNameComparison = contract1.getName().compareTo(contract2.getName());
            if (contractNameComparison == 0) {
                DeliveryArea da1 = o1.getOrderbook().getDeliveryArea();
                DeliveryArea da2 = o2.getOrderbook().getDeliveryArea();
                String da1Name = da1 == null ? "" : da1.getName().toLowerCase();
                String da2Name = da2 == null ? "" : da2.getName().toLowerCase();
                return da1Name.compareTo(da2Name);
            }
            return contractNameComparison;
        }
        return deliveryPeriodComparison;
    }

    @FXML
    public void exportCSV() {
        this.importExportService.exportOrderbookPanesToCsvFile(this.prepareExportData(), this.getScene().getWindow(), this.getFileName().replace(" ", "_"));
    }

    @FXML
    public void exportClipboard() {
        this.importExportService.exportOrderbookPanesToClipboard(this.prepareExportData());
    }

    private String getFileName() {
        LocalDate now = LocalDate.now();
        return now.toString("yyyy-MM-dd") + "-" + this.getComponentName();
    }

    private List<AbstractOrderbookPane> prepareExportData() {
        ArrayList<AbstractOrderbookPane> data = new ArrayList<AbstractOrderbookPane>();
        for (ExtendedOrderbook extendedOrderbook : this.sortedFilteredOrderbooks) {
            data.add(extendedOrderbook.getOrderbookPane());
        }
        return data;
    }

    public static class ExtendedOrderbook
    extends OrderbookValueWrapper {
        private final AbstractOrderbookPane orderbookPane;

        public ExtendedOrderbook(AbstractOrderbookPane orderbookPane, OrderbookRemovalCallback orderbookRemovalCallback, ContractAdditionOrigin origin) {
            super(orderbookPane.getOrderbook(), origin, orderbookRemovalCallback::removeOrHideOrderbook, orderbookRemovalCallback::updatedItem);
            this.orderbookPane = orderbookPane;
            this.orderbookPane.orderbookProperty().bindBidirectional(this.orderbookProperty());
        }

        public AbstractOrderbookPane getOrderbookPane() {
            return this.orderbookPane;
        }
    }

    private static class DetailedOrderbookListCell
    extends ListCell<AbstractOrderbookPane> {
        public DetailedOrderbookListCell() {
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            this.getStyleClass().addAll((String[])new String[]{"detailedOrderbookListCell", "scrollLess"});
        }

        @Override
        protected void updateItem(AbstractOrderbookPane item, boolean empty) {
            super.updateItem(item, empty);
            this.setGraphic(empty ? null : item);
            this.setPrefHeight(empty ? 50.0 : -1.0);
        }

        @Override
        protected double computeMaxWidth(double height) {
            return -1.0;
        }

        @Override
        protected double computeMinWidth(double height) {
            return -1.0;
        }

        @Override
        protected double computePrefWidth(double height) {
            return -1.0;
        }
    }

    private static final class DeliveryEndComparator
    implements Comparator<ExtendedOrderbook> {
        private boolean reverse;

        private DeliveryEndComparator(boolean reverse) {
            this.reverse = reverse;
        }

        @Override
        public int compare(ExtendedOrderbook o1, ExtendedOrderbook o2) {
            Contract contract1 = o1.getOrderbook().getContract();
            Contract contract2 = o2.getOrderbook().getContract();
            int deliveryEndComparison = contract1.getDeliveryEnd().compareTo(contract2.getDeliveryEnd());
            int n = deliveryEndComparison = this.reverse ? -deliveryEndComparison : deliveryEndComparison;
            if (deliveryEndComparison == 0) {
                int result = DetailedOrderbookPanel.compareComplex(o1, o2);
                return this.reverse ? -result : result;
            }
            return deliveryEndComparison;
        }
    }

    private static final class DeliveryStartComparator
    implements Comparator<ExtendedOrderbook> {
        private boolean reverse;

        private DeliveryStartComparator(boolean reverse) {
            this.reverse = reverse;
        }

        @Override
        public int compare(ExtendedOrderbook o1, ExtendedOrderbook o2) {
            Contract contract1 = o1.getOrderbook().getContract();
            Contract contract2 = o2.getOrderbook().getContract();
            int deliveryStartComparison = contract1.getDeliveryStart().compareTo(contract2.getDeliveryStart());
            int n = deliveryStartComparison = this.reverse ? -deliveryStartComparison : deliveryStartComparison;
            if (deliveryStartComparison == 0) {
                int result = DetailedOrderbookPanel.compareComplex(o1, o2);
                return this.reverse ? -result : result;
            }
            return deliveryStartComparison;
        }
    }

    private static final class NameComparator
    implements Comparator<ExtendedOrderbook> {
        private boolean reverse;

        private NameComparator(boolean reverse) {
            this.reverse = reverse;
        }

        @Override
        public int compare(ExtendedOrderbook o1, ExtendedOrderbook o2) {
            Contract contract1 = o1.getOrderbook().getContract();
            Contract contract2 = o2.getOrderbook().getContract();
            int nameComparison = contract1.getName().compareTo(contract2.getName());
            return this.reverse ? -nameComparison : nameComparison;
        }
    }
}

