/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.bespoke;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataQuery;
import com.deutscheboerse.comxerv.comtrader.core.entity.EntityFilters;
import com.deutscheboerse.comxerv.comtrader.domain.query.UserQueries;
import com.deutscheboerse.comxerv.comtrader.entities.Member;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.EntityAutoCompleteField;
import com.deutscheboerse.comxerv.comtrader.service.AssignmentService;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import com.deutscheboerse.ui.jfx.util.control.AutoCompleteTextField;
import java.util.Optional;
import java.util.stream.Stream;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.apache.commons.lang3.StringUtils;

public class BrokerTraderField
extends EntityAutoCompleteField<User> {
    private final UserQueries userQueries;
    private final UserService userService;
    private final AssignmentService assignmentService;
    private final ObjectProperty<Product> product;
    private final ObjectProperty<Member> member;
    private final ObjectProperty<User> trader;

    public BrokerTraderField() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public BrokerTraderField(ApplicationContext appContext) {
        super(appContext);
        this.userQueries = appContext.getService(UserQueries.class);
        this.assignmentService = appContext.getService(AssignmentService.class);
        this.userService = appContext.getService(UserService.class);
        this.product = new SimpleObjectProperty<Product>();
        this.member = new SimpleObjectProperty<Member>();
        this.trader = new SimpleObjectProperty<User>();
        this.setToStringConverter(user -> user.getMember() != null ? user.getMember().getDisplayName() + " - " + user.getDisplayName() : "");
        this.setValid(false);
    }

    @Override
    public Stream<User> getSuggestedEntities(String currentText) {
        if (this.product.get() != null && this.trader.get() != null && this.member.get() != null) {
            return this.getDataQuery().addFilter(EntityFilters.containsIgnoreCase(this.getToStringConverter(), StringUtils.trimToEmpty(currentText))).getAll().sorted(new AutoCompleteTextField.ToStringConverterComparator(this.getToStringConverter()));
        }
        return Stream.empty();
    }

    @Override
    public Optional<User> getEntity(String currentText) {
        if (this.product.get() != null && this.trader.get() != null && this.member.get() != null && this.getSuggestedEntities(currentText).findAny().isPresent()) {
            Optional<User> userOptional = this.getDataQuery().addFilter(EntityFilters.propertyEquals(this.getToStringConverter(), StringUtils.trimToEmpty(currentText))).getFirst();
            this.setValid(userOptional.isPresent());
            return userOptional;
        }
        this.setValid(false);
        return Optional.empty();
    }

    private DataQuery<User> getDataQuery() {
        return this.userQueries.findActiveBrokers().addFilter(brokerUser -> {
            User ownUser = this.userService.getOwnUser();
            if (ownUser == null) {
                return false;
            }
            return (ownUser.getRoles().isAdmin() || brokerUser.equals(ownUser) || ownUser.getRoles().isOnBehalf() && brokerUser.getMember().equals(ownUser.getMember())) && this.assignmentService.getAssignedBgIdsForBroker((User)brokerUser).stream().anyMatch(bgId -> this.assignmentService.isUserAssignedToBgAndProduct((User)this.trader.get(), (String)bgId, (String)((Product)this.product.get()).getId()));
        });
    }

    public Member getMember() {
        return (Member)this.member.get();
    }

    public ObjectProperty<Member> memberProperty() {
        return this.member;
    }

    public User getTrader() {
        return (User)this.trader.get();
    }

    public ObjectProperty<User> traderProperty() {
        return this.trader;
    }

    public Product getProduct() {
        return (Product)this.product.get();
    }

    public ObjectProperty<Product> productProperty() {
        return this.product;
    }
}

