/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.chart;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.AbstractDataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.SmallFastDataModel;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.WeakDataModelListener;
import com.deutscheboerse.comxerv.comtrader.domain.query.OrderbookQueries;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.MarketArea;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Tooltip;

public class OpeningPriceChartSeries
extends AbstractDataModelListener<Orderbook> {
    private final OrderbookQueries orderbookQueries;
    private final SmallFastDataModel<String, Orderbook> orderbookDataModel;
    private final XYChart.Series<Number, Number> chartSeries;
    private final ObservableList<XYChart.Data<Number, Number>> data;
    private final Contract contract;
    private final MarketArea marketArea;
    private final ObservableValue<Number> minXValue;

    public OpeningPriceChartSeries(ApplicationContext applicationContext, Contract contract, MarketArea marketArea, ObservableValue<Number> minXValue) {
        this.contract = contract;
        this.marketArea = marketArea;
        this.minXValue = minXValue;
        this.data = FXCollections.observableArrayList();
        this.chartSeries = new XYChart.Series(this.data);
        this.chartSeries.setName(null);
        this.orderbookQueries = applicationContext.getService(OrderbookQueries.class);
        this.orderbookDataModel = applicationContext.getSmallDataModel(Orderbook.class);
        this.reloadChart();
        this.orderbookDataModel.registerHencePostOperationListener(new WeakDataModelListener<Orderbook>(this));
        minXValue.addListener(new WeakInvalidationListener(o -> this.reloadChart()));
    }

    @Override
    public DataModelListener.NotificationResult notifyAdd(Orderbook object) {
        if (object.getContract().equals(this.contract) && object.getDeliveryArea().getMarketArea().equals(this.marketArea)) {
            this.reloadChart();
        }
        return super.notifyAdd(object);
    }

    @Override
    public DataModelListener.NotificationResult notifyUpdate(Orderbook object) {
        if (object.getContract().equals(this.contract) && object.getDeliveryArea().getMarketArea().equals(this.marketArea)) {
            this.reloadChart();
        }
        return super.notifyUpdate(object);
    }

    private void reloadChart() {
        this.data.clear();
        this.orderbookQueries.findByContract(this.contract).stream().filter(this::isAreaRelevant).collect(Collectors.groupingBy(Orderbook::getOpeningPrice)).forEach(this::addData);
    }

    private boolean isAreaRelevant(Orderbook orderbook) {
        return Optional.ofNullable(orderbook).filter(o -> o.getOpeningPrice() != null).map(Orderbook::getDeliveryArea).map(DeliveryArea::getMarketArea).filter(this.marketArea::equals).isPresent();
    }

    public XYChart.Series<Number, Number> asChartSeries() {
        return this.chartSeries;
    }

    private XYChart.Data<Number, Number> getData(LongDisplayValue openingPrice, List<Orderbook> orderbook) {
        XYChart.Data<Number, Number> numberNumberData = new XYChart.Data<Number, Number>(this.minXValue.getValue(), openingPrice.getValue());
        Tooltip tooltip = new Tooltip();
        StringBuilder tooltipText = new StringBuilder(Util.getLabel("tradesChartPanel_opening_price_tooltip_header"));
        for (Orderbook o : orderbook) {
            tooltipText.append(Util.getLabel("tradesChartPanel_opening_price_tooltip", o.getDeliveryArea().getDisplayName(), o.getOpeningPrice(), o.getContract().getProduct().getCurrencyCode()));
        }
        tooltip.setText(tooltipText.toString());
        numberNumberData.nodeProperty().addListener((observable2, oldNode, newNode) -> {
            if (oldNode != null) {
                Tooltip.uninstall(oldNode, tooltip);
            }
            if (newNode != null) {
                Tooltip.install(numberNumberData.getNode(), tooltip);
            }
        });
        return numberNumberData;
    }

    private void addData(LongDisplayValue openingPrice, List<Orderbook> orderbooks) {
        this.data.add(this.getData(openingPrice, orderbooks));
    }
}

