/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.SmallFastDataModel;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.WeakDataModelListener;
import com.deutscheboerse.comxerv.comtrader.entities.BalancingGroup;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.DisplayNameArrowKeyBlockingChoiceBox;
import com.deutscheboerse.comxerv.comtrader.service.AssignmentService;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import com.deutscheboerse.ui.jfx.util.binding.WeakObservableValue;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BalancingGroupChoiceBox
extends DisplayNameArrowKeyBlockingChoiceBox<BalancingGroup>
implements DataModelListener<BalancingGroup> {
    private static final Logger LOG = LoggerFactory.getLogger(BalancingGroupChoiceBox.class);
    private final ObjectProperty<Contract> contract;
    private final ObjectProperty<ListedItemsMode> listedItemsMode;
    private final ObjectProperty<Runnable> selectedItemRemovedCallback;
    private final SmallFastDataModel<String, BalancingGroup> balancingGroupDataModel;
    private final UserService userService;
    private final AssignmentService assignmentService;
    private final ObjectProperty<User> currentUser;
    private final ObjectProperty<User> onBehalfUser;
    private final BooleanProperty disableContractCheck = new SimpleBooleanProperty(false);
    private final InvalidationListener setItemsListener;

    public BalancingGroupChoiceBox() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public BalancingGroupChoiceBox(final ApplicationContext appContext) {
        this.onBehalfUser = new SimpleObjectProperty<Object>(null);
        this.currentUser = new SimpleObjectProperty<User>();
        this.currentUser.bind((ObservableValue<User>)new DependentBinding<User>(new Observable[]{new WeakObservableValue<User>(appContext.getService(UserService.class).currentUserProperty()), this.onBehalfUser}){

            @Override
            protected User computeValue() {
                return Optional.ofNullable((User)BalancingGroupChoiceBox.this.onBehalfUser.get()).orElse((User)appContext.getService(UserService.class).currentUserProperty().get());
            }
        });
        this.listedItemsMode = new SimpleObjectProperty<ListedItemsMode>(ListedItemsMode.MANUAL);
        this.contract = new SimpleObjectProperty<Object>(null);
        this.selectedItemRemovedCallback = new SimpleObjectProperty<Object>(null);
        this.balancingGroupDataModel = appContext.getSmallDataModel(BalancingGroup.class);
        this.userService = appContext.getService(UserService.class);
        this.assignmentService = appContext.getService(AssignmentService.class);
        this.setItemsListener = observable2 -> this.setListedItems(this.computeListedItems());
        this.listedItemsMode.addListener(this.setItemsListener);
        this.currentUser.addListener(this.setItemsListener);
        this.contract.addListener(this.setItemsListener);
        this.disableContractCheck.addListener(this.setItemsListener);
        this.balancingGroupDataModel.registerListener(new WeakDataModelListener<BalancingGroup>(this));
    }

    @Override
    public DataModelListener.NotificationResult notifyAdd(BalancingGroup object) {
        return this.handleDataModelChange();
    }

    @Override
    public DataModelListener.NotificationResult notifyAddAll(Collection<BalancingGroup> objects) {
        for (BalancingGroup balancingGroup : objects) {
            this.notifyAdd(balancingGroup);
        }
        return DataModelListener.NotificationResult.RETAIN_LISTENER;
    }

    @Override
    public DataModelListener.NotificationResult notifyRemove(BalancingGroup object) {
        if (object.equals(this.getValue()) && this.getSelectedItemRemovedCallback() != null) {
            this.getSelectedItemRemovedCallback().run();
        }
        return this.handleDataModelChange();
    }

    @Override
    public DataModelListener.NotificationResult notifyRemoveAll(Collection<BalancingGroup> objects) {
        for (BalancingGroup object : objects) {
            this.notifyRemove(object);
        }
        return DataModelListener.NotificationResult.RETAIN_LISTENER;
    }

    @Override
    public DataModelListener.NotificationResult notifyRemoveAll() {
        return DataModelListener.NotificationResult.REMOVE_LISTENER;
    }

    @Override
    public DataModelListener.NotificationResult notifyUpdate(BalancingGroup object) {
        return DataModelListener.NotificationResult.RETAIN_LISTENER;
    }

    @Override
    public DataModelListener.NotificationResult notifyUpdateAll(Collection<BalancingGroup> objects) {
        return DataModelListener.NotificationResult.RETAIN_LISTENER;
    }

    private DataModelListener.NotificationResult handleDataModelChange() {
        this.setListedItems(this.computeListedItems());
        return DataModelListener.NotificationResult.RETAIN_LISTENER;
    }

    private List<BalancingGroup> computeListedItems() {
        ArrayList<BalancingGroup> balancingGroups = new ArrayList<BalancingGroup>();
        Contract currentContract = (Contract)this.contract.getValue();
        if (currentContract == null && !this.disableContractCheck.get()) {
            return Lists.newArrayList();
        }
        ListedItemsMode mode = this.getListedItemsMode();
        switch (mode.ordinal()) {
            case 3: {
                balancingGroups.addAll(this.getListedItems());
                break;
            }
            case 0: {
                balancingGroups.addAll(this.balancingGroupDataModel.getAllEntitiesAsStream().toList());
                break;
            }
            case 1: {
                balancingGroups.addAll(this.balancingGroupDataModel.getAllEntitiesAsStream().filter(this::isOwnBalancingGroup).toList());
                break;
            }
            case 2: {
                this.balancingGroupDataModel.getAllEntitiesAsStream().filter(bg -> !this.isOwnBalancingGroup((BalancingGroup)bg) && bg.isOtcTrading()).forEach(balancingGroups::add);
            }
        }
        if (!this.disableContractCheck.get() && mode == ListedItemsMode.ONLY_OWN_BALANCING_GROUPS) {
            User user = (User)this.currentUser.get();
            if (user != null && currentContract != null) {
                User ownUser = this.userService.getOwnUser();
                String productId = (String)currentContract.getProduct().getId();
                balancingGroups.removeIf(bg -> !this.assignmentService.isUserAssignedToBgAndProduct(user, (String)bg.getId(), productId));
                if (ownUser != null && ownUser.getRoles().isBroker() && ObjectUtils.notEqual(ownUser.getMemberId(), user.getMemberId())) {
                    balancingGroups.removeIf(bg -> !this.assignmentService.getAssignedBgIdsForBroker(ownUser).contains(bg.getId()));
                }
            } else {
                balancingGroups.clear();
            }
        }
        Collections.sort(balancingGroups, (o1, o2) -> o1.getName().compareTo(o2.getName()));
        LOG.trace("BG's mode {}:{}", (Object)mode, (Object)balancingGroups);
        return balancingGroups;
    }

    private boolean isOwnBalancingGroup(BalancingGroup balancingGroup) {
        User user = (User)this.currentUser.getValue();
        return user.containsBalancingGroupId((String)balancingGroup.getId());
    }

    private void setListedItems(List<BalancingGroup> items) {
        if (!items.equals(this.getListedItems())) {
            BalancingGroup currentSelection = (BalancingGroup)this.getValue();
            boolean doReselect = items.contains(currentSelection);
            if (!doReselect) {
                this.setValue(null);
            }
            super.setListedItems(items);
            if (doReselect) {
                this.setValue(currentSelection);
            } else if (!items.isEmpty()) {
                this.setValue(items.get(0));
            } else {
                this.setValue(null);
            }
        }
    }

    public User getOnBehalfUser() {
        return (User)this.onBehalfUser.get();
    }

    public ObjectProperty<User> onBehalfUserProperty() {
        return this.onBehalfUser;
    }

    public Contract getContract() {
        return (Contract)this.contract.get();
    }

    public ObjectProperty<Contract> contractProperty() {
        return this.contract;
    }

    public void setContract(Contract contract) {
        this.contract.set(contract);
    }

    public ListedItemsMode getListedItemsMode() {
        return (ListedItemsMode)((Object)this.listedItemsMode.get());
    }

    public ObjectProperty<ListedItemsMode> listedItemsModeProperty() {
        return this.listedItemsMode;
    }

    public void setListedItemsMode(ListedItemsMode listedItemsMode) {
        this.listedItemsMode.set(listedItemsMode);
    }

    public Runnable getSelectedItemRemovedCallback() {
        return (Runnable)this.selectedItemRemovedCallback.get();
    }

    public ObjectProperty<Runnable> selectedItemRemovedCallbackProperty() {
        return this.selectedItemRemovedCallback;
    }

    public void setSelectedItemRemovedCallback(Runnable selectedItemRemovedCallback) {
        this.selectedItemRemovedCallback.set(selectedItemRemovedCallback);
    }

    public void setSelectedById(String bgEntityId) {
        this.getListedItems().stream().filter(bg -> ((String)bg.getId()).equals(bgEntityId)).findFirst().ifPresent(this::setValue);
    }

    public boolean isDisableContractCheck() {
        return this.disableContractCheck.get();
    }

    public void setDisableContractCheck(boolean disableContractCheck) {
        this.disableContractCheck.set(disableContractCheck);
    }

    public BooleanProperty disableContractCheckProperty() {
        return this.disableContractCheck;
    }

    public static enum ListedItemsMode {
        ALL,
        ONLY_OWN_BALANCING_GROUPS,
        ALL_BUT_OWN_BALANCING_GROUPS,
        MANUAL;

    }
}

