/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModel;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.type.ProductType;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.AbstractProductField;
import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import java.util.Optional;
import java.util.stream.Stream;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;

public class BlockProductField
extends AbstractProductField {
    private final DataModel<String, Product> productDataModel;
    private final ObjectProperty<Product> baseProductValue;

    public BlockProductField() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public BlockProductField(ApplicationContext appContext) {
        super(appContext);
        this.productDataModel = appContext.getSmallDataModel(Product.class);
        this.baseProductValue = new SimpleObjectProperty<Product>();
        this.baseProductValue.bind((ObservableValue<Product>)new DependentBinding<Product>(new Observable[]{this.valueProperty()}){

            @Override
            protected Product computeValue() {
                Product product = (Product)BlockProductField.this.valueProperty().get();
                if (product == null) {
                    return null;
                }
                if (product.isBlockOrderProduct()) {
                    return product;
                }
                return BlockProductField.this.productDataModel.findById(product.getBaseProductId());
            }
        });
    }

    @Override
    public Stream<Product> getSuggestedEntities(String currentText) {
        if (this.getValue() == null) {
            return this.productQueries.findActiveProductsByNameStart(currentText).addFilter(product -> product.getProductType() == ProductType.USER_DEFINED_DELIVERY_PERIOD || product.isBlockOrderProduct()).getAll().sorted(Product.DEFAULT_DISPLAY_COMPARATOR);
        }
        return this.productQueries.findActiveProductsByNameStart("").addFilter(product -> product.getProductType() == ProductType.USER_DEFINED_DELIVERY_PERIOD && product.getBaseProductId().equals(((Product)this.getValue()).getBaseProductId()) || product.isBlockOrderProduct() && ((String)product.getId()).equals(((Product)this.getValue()).getId())).getAll().sorted(Product.DEFAULT_DISPLAY_COMPARATOR);
    }

    @Override
    public Optional<Product> getEntity(String currentText) {
        return this.productQueries.findActiveProductsByName(currentText).addFilter(product -> product.getProductType() == ProductType.USER_DEFINED_DELIVERY_PERIOD || product.isBlockOrderProduct()).getFirst();
    }

    public Product getBaseProductValue() {
        return (Product)this.baseProductValue.get();
    }

    public ReadOnlyObjectProperty<Product> baseProductValueProperty() {
        return this.baseProductValue;
    }
}

