/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control.bottomtoolbar;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.util.TooltipUtils;
import com.deutscheboerse.comxerv.comtrader.service.time.TimeService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import com.deutscheboerse.ui.jfx.util.control.ArrowKeyBlockingChoiceBox;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.util.StringConverter;
import org.apache.commons.lang3.IntegerRange;

public class TimeframeChoiceBox
extends ArrowKeyBlockingChoiceBox<IntegerRange> {
    private final TimeService timeService;
    private final List<IntegerRange> values = new ArrayList<IntegerRange>();
    private final ObjectProperty<Integer> hourInterval;

    public TimeframeChoiceBox() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    protected TimeframeChoiceBox(ApplicationContext applicationContext) {
        super(new StringConverter<IntegerRange>(){

            @Override
            public String toString(IntegerRange range) {
                if (range != null) {
                    return range.toString("%1$02d - %2$02d");
                }
                return null;
            }

            @Override
            public IntegerRange fromString(String string) {
                throw new UnsupportedOperationException();
            }
        });
        this.timeService = applicationContext.getService(TimeService.class);
        InvalidationListener reloadValuesListener = observable2 -> this.init();
        this.hourInterval = new SimpleObjectProperty<Integer>();
        this.hourInterval.addListener(reloadValuesListener);
        TooltipUtils.setTooltip(this, Util.getLabel("descriptions_toolbar_allTradePanel_timframe_tooltip"));
        this.init();
    }

    public void init() {
        this.computeValues();
        FxUtil.runInFxThread(() -> {
            this.setListedItems(this.values);
            this.selectCurrentTimeframe();
        });
    }

    public void selectCurrentTimeframe() {
        if (this.timeService.getServerTime() != null) {
            int hourOfDay = this.timeService.getServerTime().getHourOfDay();
            this.getListedItems().stream().filter(ir -> (Integer)ir.getMinimum() <= hourOfDay && (Integer)ir.getMaximum() > hourOfDay).findFirst().ifPresent(ir -> this.setValue(ir));
        }
    }

    public ObjectProperty<Integer> hourIntervalProperty() {
        return this.hourInterval;
    }

    private void computeValues() {
        this.values.clear();
        if (this.hourInterval.getValue() != null) {
            int interval = (Integer)this.hourInterval.getValue();
            int i = 1;
            while (i * interval <= 24) {
                this.values.add(IntegerRange.of(i * interval - interval, i * interval));
                ++i;
            }
        }
    }
}

