/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control.bottomtoolbar;

import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.toolbar.BottomToolbarNode;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.control.Label;

public class TotalsCounter
extends Label
implements BottomToolbarNode {
    private final ObjectProperty<Integer> totalItems = new SimpleObjectProperty<Integer>(0);
    private final ObjectProperty<Integer> shownItems = new SimpleObjectProperty<Integer>(0);

    public TotalsCounter() {
        this.textProperty().bind(DependentBinding.get(this::computeText, this.totalItems, this.shownItems));
    }

    private String computeText() {
        int shown;
        int total = (Integer)this.totalItems.get();
        if (total == (shown = ((Integer)this.shownItems.get()).intValue())) {
            return Integer.toString(total);
        }
        return Integer.toString(shown) + " (" + Integer.toString(total) + ")";
    }

    @Override
    public Node getPreviewForConfigTable() {
        Label preview = new Label();
        preview.textProperty().bind(this.textProperty());
        preview.setDisable(true);
        return preview;
    }

    @Override
    public String getDescription() {
        return Util.getLabel("descriptions_toolbar_totals");
    }

    public Integer getTotalItems() {
        return (Integer)this.totalItems.get();
    }

    public ObjectProperty<Integer> totalItemsProperty() {
        return this.totalItems;
    }

    public void setTotalItems(Integer totalItems) {
        this.totalItems.set(totalItems);
    }

    public Integer getShownItems() {
        return (Integer)this.shownItems.get();
    }

    public ObjectProperty<Integer> shownItemsProperty() {
        return this.shownItems;
    }

    public void setShownItems(Integer shownItems) {
        this.shownItems.set(shownItems);
    }
}

