/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.customization.toolbar;

import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.toolbar.BottomToolbarNode;
import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.toolbar.LabeledBottomToolbarNode;
import com.deutscheboerse.comxerv.comtrader.jfx.components.icon.IconView;
import com.deutscheboerse.comxerv.comtrader.jfx.util.TooltipUtils;
import com.deutscheboerse.ui.jfx.util.StyleUtil;
import java.util.Collection;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.ToggleButton;
import org.apache.commons.lang3.BooleanUtils;

public class LabeledBottomToolbarToggleButton
extends ToggleButton
implements BottomToolbarNode,
LabeledBottomToolbarNode {
    private final BooleanProperty showLabel = new SimpleBooleanProperty(this.getContentDisplay() != ContentDisplay.GRAPHIC_ONLY);
    private final StringProperty description;
    private final IconView icon = new IconView();
    private String iconStyleClass;

    public LabeledBottomToolbarToggleButton() {
        this.setGraphic(this.icon);
        this.description = new SimpleStringProperty();
        this.setPrefWidth(-1.0);
        this.setMinWidth(Double.NEGATIVE_INFINITY);
        this.showLabel.addListener((observable2, oldValue, newValue) -> this.setContentDisplay(BooleanUtils.isTrue(newValue) ? ContentDisplay.LEFT : ContentDisplay.GRAPHIC_ONLY));
        this.description.addListener((observable2, oldValue, newValue) -> TooltipUtils.setTooltip(this, newValue));
    }

    @Override
    public Node getPreviewForConfigTable() {
        IconView proxyIcon = new IconView();
        StyleUtil.addStyleClass(proxyIcon, this.getIconStyleClass());
        Label proxyLabel = new Label();
        proxyLabel.setGraphic(proxyIcon);
        proxyLabel.setText(this.getText());
        proxyLabel.contentDisplayProperty().bind(this.contentDisplayProperty());
        proxyLabel.getStyleClass().addAll((Collection<String>)this.getStyleClass());
        proxyLabel.setDisable(true);
        return proxyLabel;
    }

    public String getIconStyleClass() {
        return this.iconStyleClass;
    }

    public void setIconStyleClass(String iconStyleClass) {
        this.icon.getStyleClass().remove(this.iconStyleClass);
        this.iconStyleClass = iconStyleClass;
        this.icon.getStyleClass().add(iconStyleClass);
    }

    @Override
    public String getDescription() {
        return (String)this.description.get();
    }

    public StringProperty descriptionProperty() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description.set(description);
    }

    @Override
    public boolean isShowLabel() {
        return this.showLabel.get();
    }

    @Override
    public BooleanProperty showLabelProperty() {
        return this.showLabel;
    }

    @Override
    public void setShowLabel(boolean showLabel) {
        this.showLabel.set(showLabel);
    }
}

