/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.layout;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.Destroyable;
import com.deutscheboerse.comxerv.comtrader.jfx.components.PanelWithLoadingIndicator;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.AlwaysTrueShowLoadingIndicatorRule;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.ShowLoadingIndicatorRule;
import com.deutscheboerse.comxerv.comtrader.jfx.components.layout.PanelOverlay;
import com.deutscheboerse.comxerv.comtrader.service.event.EntityLoadingFinishedEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.EntityLoadingStartedEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.LoadingStartedEvent;
import com.google.common.collect.Lists;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class LoadingOverlay
extends StackPane
implements PanelOverlay,
Destroyable {
    private final ShowLoadingIndicatorRule indicatorRule;
    private final List<? extends Class<? extends BroadcastEntity>> entityClasses;
    private final EventBus eventBus;
    @FXML
    private VBox controlsContainer;
    private final BooleanProperty loading = new SimpleBooleanProperty(false);
    private final AtomicInteger currentlyLoadingClasses = new AtomicInteger(0);

    public LoadingOverlay(ApplicationContext applicationContext, PanelWithLoadingIndicator loadingIndicatorAnnotation) {
        this.eventBus = applicationContext.getService(EventBus.class);
        if (loadingIndicatorAnnotation != null) {
            this.indicatorRule = this.getShowLoadingIndicatorRule(loadingIndicatorAnnotation);
            this.entityClasses = Lists.newArrayList(loadingIndicatorAnnotation.entityClasses());
        } else {
            this.indicatorRule = new AlwaysTrueShowLoadingIndicatorRule();
            this.entityClasses = Collections.emptyList();
        }
        FXMLLoaderWithContext.loadCustomComponent(this);
        this.eventBus.register(this);
    }

    private ShowLoadingIndicatorRule getShowLoadingIndicatorRule(PanelWithLoadingIndicator loadingIndicatorAnnotation) {
        try {
            return loadingIndicatorAnnotation.showLoadingIndicatorRule().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public void initialize() {
        StackPane.setAlignment(this.controlsContainer, Pos.CENTER);
    }

    @Override
    public Pane getOverlayPane() {
        return this;
    }

    @Override
    public void destroy() {
        this.eventBus.unregister(this);
    }

    @Subscribe
    public void handleEntityLoadingStarted(EntityLoadingStartedEvent entityLoadingStartedEvent) {
        if (this.entityClasses.contains(entityLoadingStartedEvent.getEntityClass()) && !this.currentlyLoadingClasses.compareAndSet(0, 1)) {
            this.currentlyLoadingClasses.incrementAndGet();
        }
    }

    @Subscribe
    public void handleLoadingStarted(LoadingStartedEvent loadingStartedEvent) {
        if (!this.entityClasses.isEmpty() && (loadingStartedEvent == null || this.indicatorRule.evaluate(loadingStartedEvent.getSession()))) {
            this.loading.setValue(true);
        }
    }

    @Subscribe
    public void handleEntityLoadingFinished(EntityLoadingFinishedEvent entityLoadingFinishedEvent) {
        if (this.entityClasses.contains(entityLoadingFinishedEvent.getEntityClass())) {
            if (this.currentlyLoadingClasses.compareAndSet(1, 0)) {
                this.loading.setValue(false);
            } else {
                this.currentlyLoadingClasses.decrementAndGet();
            }
        }
    }

    @Override
    public ReadOnlyBooleanProperty shouldBeVisible() {
        return this.loading;
    }
}

