/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.login;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.session.ConnectionParametersWithFallback;
import com.deutscheboerse.comxerv.comtrader.entities.session.OrderbookApiVersionType;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.util.converter.DisplayNameConverter;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.layout.GridPane;

public class AdvancedLoginPane
extends GridPane {
    @FXML
    private CheckBox receivePblcOrdrBooksDeltaRprtCheckBox;
    @FXML
    private CheckBox receivePblcTradeConfRprtCheckBox;
    @FXML
    private CheckBox useShortOrderbookBatchingCheckBox;
    @FXML
    private ChoiceBox<OrderbookApiVersionType> orderbookApiVersionChoiceBox;
    @FXML
    private ChoiceBox<OrderbookApiVersionType> privateDataApiVersionChoiceBox;

    public AdvancedLoginPane() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public AdvancedLoginPane(ApplicationContext applicationContext) {
        FXMLLoaderWithContext.loadCustomComponent(applicationContext, this);
    }

    public void initialize() {
        this.orderbookApiVersionChoiceBox.setItems(FXCollections.observableArrayList(null, OrderbookApiVersionType.V6, OrderbookApiVersionType.V7, OrderbookApiVersionType.BOTH));
        this.orderbookApiVersionChoiceBox.setConverter(new DisplayNameConverter());
        this.orderbookApiVersionChoiceBox.getSelectionModel().selectFirst();
        this.privateDataApiVersionChoiceBox.setItems(FXCollections.observableArrayList(null, OrderbookApiVersionType.V6, OrderbookApiVersionType.V7, OrderbookApiVersionType.BOTH));
        this.privateDataApiVersionChoiceBox.setConverter(new DisplayNameConverter());
        this.privateDataApiVersionChoiceBox.getSelectionModel().selectFirst();
    }

    public void loadConnectionParameters(ConnectionParametersWithFallback connectionParameters) {
        this.receivePblcOrdrBooksDeltaRprtCheckBox.setSelected(connectionParameters.isReceivePblcOrdrBooksDeltaRprt());
        this.receivePblcTradeConfRprtCheckBox.setSelected(connectionParameters.isReceivePblcTradeConfRprt());
        this.useShortOrderbookBatchingCheckBox.setSelected(connectionParameters.isUseShortOrderbookBatching());
        if (connectionParameters.getOrderbookApiVersion() != null) {
            this.orderbookApiVersionChoiceBox.setValue(OrderbookApiVersionType.valueOf(connectionParameters.getOrderbookApiVersion()));
        }
        if (connectionParameters.getPrivateDataApiVersion() != null) {
            this.privateDataApiVersionChoiceBox.setValue(OrderbookApiVersionType.valueOf(connectionParameters.getPrivateDataApiVersion()));
        }
    }

    public void setConnectionParametersValues(ConnectionParametersWithFallback connectionParameters) {
        connectionParameters.setReceivePblcOrdrBooksDeltaRprt(this.getReceivePblcOrdrBooksDeltaRprt());
        connectionParameters.setReceivePblcTradeConfRprt(this.getReceivePblcTradeConfRprt());
        connectionParameters.setUseLongOrderbookBatching(this.getUseShortOrderbookBatching());
        if (this.orderbookApiVersionChoiceBox.getValue() != null) {
            connectionParameters.setOrderbookApiVersion(this.orderbookApiVersionChoiceBox.getValue().name());
        }
        if (this.privateDataApiVersionChoiceBox.getValue() != null) {
            connectionParameters.setPrivateDataApiVersion(this.privateDataApiVersionChoiceBox.getValue().name());
        }
    }

    private boolean getReceivePblcOrdrBooksDeltaRprt() {
        return this.receivePblcOrdrBooksDeltaRprtCheckBox.isSelected();
    }

    private boolean getReceivePblcTradeConfRprt() {
        return this.receivePblcTradeConfRprtCheckBox.isSelected();
    }

    private boolean getUseShortOrderbookBatching() {
        return this.useShortOrderbookBatchingCheckBox.isSelected();
    }
}

