/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.mainpanel;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.jfx.components.icon.IconView;
import com.deutscheboerse.comxerv.comtrader.jfx.components.mainpanel.ChangePasswordPane;
import com.deutscheboerse.comxerv.comtrader.jfx.service.NotificationService;
import com.deutscheboerse.comxerv.comtrader.service.UserAlertService;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseHandler;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseStatus;
import com.deutscheboerse.comxerv.comtrader.service.user.ChangePasswordService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import com.deutscheboerse.ui.jfx.util.StyleUtil;
import com.google.inject.Inject;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.geometry.Pos;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.stage.Window;

public class ChangePasswordDialog
extends Dialog<Void> {
    private final ChangePasswordPane changePasswordPane;
    private final NotificationService.Notifier notifier;
    private final ApplicationContext appContext;
    private final UserAlertService userAlertService;

    @Inject
    public ChangePasswordDialog(ApplicationContext appContext) {
        this.appContext = appContext;
        this.userAlertService = this.appContext.getService(UserAlertService.class);
        this.changePasswordPane = new ChangePasswordPane(appContext);
        this.notifier = appContext.getService(NotificationService.class).createNotifier(this.getDialogPane(), Pos.BOTTOM_CENTER);
        this.getDialogPane().setContent(this.changePasswordPane);
        this.setGraphic(new IconView("icon-info-32"));
        StyleUtil.addStyleClass(this.getDialogPane(), "jfxDialog");
        this.setTitle(Util.getLabel("comXervClient_menuItem_changePassword"));
        this.setHeaderText(Util.getLabel("commons_changePasswordDefaultStatus"));
        this.getDialogPane().getButtonTypes().addAll((ButtonType[])new ButtonType[]{ButtonType.CANCEL, ButtonType.OK});
        Platform.runLater(() -> this.changePasswordPane.getOldPassword().requestFocus());
    }

    public void show(Window parent, Exchange exchange) {
        this.prepare(parent, exchange);
        this.showAndWait();
    }

    protected void prepare(Window parent, Exchange exchange) {
        this.initOwner(parent);
        Button okButton = (Button)this.getDialogPane().lookupButton(ButtonType.OK);
        okButton.disableProperty().bind(this.changePasswordPane.getOldPassword().textProperty().isEmpty().or(this.changePasswordPane.getNewPassword().textProperty().isEmpty()).or(this.changePasswordPane.getNewPasswordConfirmed().textProperty().isEmpty()));
        okButton.addEventFilter(ActionEvent.ACTION, (? super T event) -> {
            this.doChange(exchange);
            event.consume();
        });
    }

    private ResponseHandler createResponseHandler() {
        return response -> {
            if (ResponseStatus.SUCCESS.equals((Object)response.getStatus())) {
                this.userAlertService.showConfirmationDialog(Util.getLabel("commons_changePassword"), Util.getLabel("commons_changePasswordSuccess"), UserAlertService.Flag.INFO);
                this.close();
            } else {
                FxUtil.runInFxThread(() -> this.notifier.showNotification(response));
            }
        };
    }

    private void doChange(Exchange exchange) {
        ChangePasswordService changePasswordService = this.appContext.getService(ChangePasswordService.class, exchange);
        String oldPwd = this.changePasswordPane.getOldPassword().getText();
        String newPwd = this.changePasswordPane.getNewPassword().getText();
        String newPwdConf = this.changePasswordPane.getNewPasswordConfirmed().getText();
        changePasswordService.changePassword(oldPwd, newPwd, newPwdConf, this.createResponseHandler());
    }
}

