/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.AbstractAreaChoiceBox;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.ButtonWithIcon;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.ContractPhaseWidget;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.DeliveryAreaChoiceBox;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.FlashingLabel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.ValueChangeWidget;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.AbstractOrderbookPane;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.CloseRemoveOrderbookCallBack;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.ExtendedOrderbookTables;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideExcelConfiguration;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.text.Text;

@OverrideExcelConfiguration(overrideId="ExtendedOrderbookPaneExcelExeport")
public class ExtendedOrderbookPane
extends AbstractOrderbookPane {
    public ExtendedOrderbookPane(ApplicationContext appContext, Orderbook initialOrderbook, CloseRemoveOrderbookCallBack closeRemoveOrderbookCallBack, ObservableValue<Integer> rowLimit, AbstractAreaChoiceBox switchAllDaChoiceBox, boolean scrollLess) {
        super(appContext, initialOrderbook, closeRemoveOrderbookCallBack, rowLimit, switchAllDaChoiceBox);
        this.setupComponentInternally(scrollLess);
        this.initialize();
    }

    private void setupComponentInternally(boolean scrollLess) {
        HBox extendedOrderbookPaneHeader = new HBox();
        extendedOrderbookPaneHeader.getStyleClass().add("extendedOrderbookPaneHeader");
        extendedOrderbookPaneHeader.setPrefHeight(25.0);
        extendedOrderbookPaneHeader.setOnMouseClicked(this::toggleCollapse);
        extendedOrderbookPaneHeader.setPadding(new Insets(2.0, 2.0, 2.0, 2.0));
        HBox left = new HBox();
        left.setFillHeight(false);
        left.setAlignment(Pos.CENTER_LEFT);
        left.setSpacing(5.0);
        this.daChoiceBox = new DeliveryAreaChoiceBox(this.appContext);
        this.daChoiceBox.setListedItemsMode(AbstractAreaChoiceBox.ListedItemsMode.MANUAL);
        this.daChoiceBox.setId("daChoiceBox");
        HBox contractNameContainer = new HBox();
        contractNameContainer.setMinWidth(105.0);
        contractNameContainer.setMaxWidth(250.0);
        contractNameContainer.setAlignment(Pos.CENTER_LEFT);
        contractNameContainer.setFillHeight(true);
        contractNameContainer.setSpacing(1.0);
        this.name = new Label();
        this.name.setId("name");
        this.name.getStyleClass().addAll((String[])new String[]{"headerLabel", "strong"});
        contractNameContainer.getChildren().add(this.name);
        Region region1 = new Region();
        region1.setPrefWidth(5.0);
        region1.setPrefHeight(25.0);
        Text hiLoText = new Text();
        hiLoText.setText(Util.getLabel("extendedOrderbookPane_hiLo"));
        hiLoText.getStyleClass().addAll((String[])new String[]{"headerLabel", "strong"});
        HBox hiLoContainer = new HBox();
        hiLoContainer.setAlignment(Pos.CENTER_LEFT);
        hiLoContainer.setFillHeight(false);
        this.highText = new FlashingLabel(this.appContext);
        this.highText.setId("highText");
        this.highText.getStyleClass().addAll((String[])new String[]{"headerLabel", "strong"});
        this.highText.setAlignment(Pos.CENTER_LEFT);
        Text slash = new Text("/");
        slash.getStyleClass().addAll((String[])new String[]{"headerLabel", "strong"});
        this.lowText = new FlashingLabel(this.appContext);
        this.lowText.setId("lowText");
        this.lowText.getStyleClass().addAll((String[])new String[]{"headerLabel", "strong"});
        this.lowText.setAlignment(Pos.CENTER_LEFT);
        hiLoContainer.getChildren().addAll((Node[])new Node[]{this.highText, slash, this.lowText});
        Region region2 = new Region();
        region2.setPrefWidth(5.0);
        region2.setPrefHeight(25.0);
        Text lastQtyPrcText = new Text();
        lastQtyPrcText.setText(Util.getLabel("extendedOrderbookPane_last"));
        lastQtyPrcText.getStyleClass().addAll((String[])new String[]{"headerLabel", "strong"});
        this.lastQtyPrcContainer = new HBox();
        this.lastQtyPrcContainer.setFillHeight(false);
        this.lastQtyPrcContainer.setAlignment(Pos.CENTER_LEFT);
        this.lastQtyText = new FlashingLabel(this.appContext);
        this.lastQtyText.setId("lastQtyText");
        this.lastQtyText.getStyleClass().addAll((String[])new String[]{"headerLabel", "strong"});
        this.lastQtyText.setAlignment(Pos.CENTER_LEFT);
        Text at = new Text(Util.getLabel("commons_at"));
        at.getStyleClass().addAll((String[])new String[]{"headerLabel", "strong"});
        this.lastPrcText = new FlashingLabel(this.appContext);
        this.lastPrcText.setId("lastPrcText");
        this.lastPrcText.getStyleClass().addAll((String[])new String[]{"headerLabel", "strong"});
        this.lastPrcText.setAlignment(Pos.CENTER_LEFT);
        this.lastQtyPrcContainer.getChildren().addAll((Node[])new Node[]{this.lastQtyText, at, this.lastPrcText});
        this.valueChangeWidget = new ValueChangeWidget();
        HBox closingPriceContainer = new HBox();
        closingPriceContainer.setSpacing(2.0);
        closingPriceContainer.setAlignment(Pos.CENTER_LEFT);
        closingPriceContainer.setFillHeight(false);
        closingPriceContainer.setId("closingPriceContainer");
        Text closingPriceLabel = new Text(Util.getLabel("commons_closingPriceShort_colon"));
        closingPriceLabel.getStyleClass().addAll((String[])new String[]{"headerLabel", "strong"});
        this.closingPriceText = new FlashingLabel(this.appContext);
        this.closingPriceText.getStyleClass().addAll((String[])new String[]{"headerLabel", "strong"});
        closingPriceContainer.getChildren().addAll((Node[])new Node[]{closingPriceLabel, this.closingPriceText});
        this.auctionHBox = new HBox();
        this.auctionHBox.setFillHeight(false);
        this.auctionHBox.setAlignment(Pos.CENTER_LEFT);
        this.auctionHBox.setSpacing(5.0);
        this.auctionHBox.setId("auctionHBox");
        this.auctionHBox.setVisible(false);
        Text surplusLabel = new Text(Util.getLabel("commons_surplus_space"));
        surplusLabel.getStyleClass().addAll((String[])new String[]{"headerLabel", "strong"});
        this.surplusText = new FlashingLabel(this.appContext);
        this.surplusText.setId("surplusText");
        this.surplusText.getStyleClass().addAll((String[])new String[]{"headerLabel", "strong"});
        this.surplusText.setAlignment(Pos.CENTER_LEFT);
        Region region3 = new Region();
        region3.setPrefWidth(5.0);
        region3.setPrefHeight(25.0);
        this.auctionHBox.getChildren().addAll((Node[])new Node[]{surplusLabel, this.surplusText, region3});
        left.getChildren().addAll((Node[])new Node[]{this.daChoiceBox, contractNameContainer, region1, hiLoText, hiLoContainer, region2, lastQtyPrcText, this.lastQtyPrcContainer, this.valueChangeWidget, closingPriceContainer, this.auctionHBox});
        HBox center = new HBox();
        HBox.setHgrow(center, Priority.ALWAYS);
        HBox right = new HBox();
        right.setFillHeight(false);
        right.setPrefHeight(25.0);
        right.setAlignment(Pos.CENTER_RIGHT);
        right.setSpacing(5.0);
        this.phaseWidget = new ContractPhaseWidget();
        this.phaseWidget.setMinWidth(20.0);
        this.closeButton = new ButtonWithIcon("", "button-close");
        this.closeButton.setOnAction(event -> this.close());
        right.getChildren().addAll((Node[])new Node[]{this.phaseWidget, this.closeButton});
        extendedOrderbookPaneHeader.getChildren().addAll((Node[])new Node[]{left, center, right});
        this.entryTables = new ExtendedOrderbookTables(this.appContext, false, scrollLess);
        this.getChildren().addAll((Node[])new Node[]{extendedOrderbookPaneHeader, this.entryTables});
    }
}

