/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.producttimeline;

import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.jfx.components.producttimeline.ProductListView;
import com.deutscheboerse.comxerv.comtrader.jfx.components.tree.AbstractContractTreeContext;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;

public class ProductTimelineContractTreeContext
extends AbstractContractTreeContext {
    private final Set<Product> subscribedProducts = new HashSet<Product>();
    private final ProductListView productListView;

    public ProductTimelineContractTreeContext(Predicate<Contract> contractFilter, Predicate<Product> productFilter, ProductListView productListView) {
        super(contractFilter, productFilter);
        this.productListView = productListView;
    }

    @Override
    public boolean isSelectable(Contract contract) {
        return false;
    }

    @Override
    public boolean isSelectable(Product product) {
        return false;
    }

    @Override
    public boolean areProductsSubscribable() {
        return true;
    }

    @Override
    public boolean isSubscribed(Product product) {
        return this.subscribedProducts.contains(product);
    }

    @Override
    public void productSubscribed(Product product) {
        this.subscribedProducts.add(product);
        this.productListView.addProduct(product);
    }

    @Override
    public void productUnsubscribed(Product product) {
        this.subscribedProducts.remove(product);
        this.productListView.removeProduct(product);
    }

    @Override
    public void productSelected(Product product) {
    }

    @Override
    public void contractSelected(Contract contract) {
    }

    public Set<Product> getSubscribedProducts() {
        return Collections.unmodifiableSet(this.subscribedProducts);
    }
}

