/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.table;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.H2HArea;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.TableColumnWithTooltip;
import com.deutscheboerse.comxerv.comtrader.jfx.components.h2h.HubToHubRow;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.CapacityValue;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.CapacityValueCellCustomizer;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.CapacityValueCellValueFactory;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.GenericCellFactory;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import javafx.geometry.Pos;
import javafx.scene.control.ContentDisplay;

public class CapacityColumn<O extends HubToHubRow>
extends TableColumnWithTooltip<O, CapacityValue> {
    public static final char H2H_MA_COLUMN_ID_DIVIDER = '_';
    public static final char H2H_MA_ARROW = '\u2192';

    public CapacityColumn(ApplicationContext applicationContext, H2HArea fromArea, H2HArea toArea) {
        String fromMA = fromArea.getDisplayName();
        String toMA = toArea.getDisplayName();
        this.setId(fromMA + "_" + toMA);
        this.setLabelText(fromMA + "\u2192" + toMA);
        this.setTooltipText(Util.getLabel("hubToHub_atc_column_tooltip", fromMA, toMA));
        this.setDescription(Util.getLabel("hubToHub_atc_column_desc", fromMA, toMA));
        this.setMinWidth(70.0);
        this.setPrefWidth(120.0);
        this.setSortable(false);
        this.setVisible(false);
        this.setCellValueFactory(new CapacityValueCellValueFactory((String)fromArea.getId(), (String)toArea.getId()));
        GenericCellFactory cellFactory = new GenericCellFactory(applicationContext);
        cellFactory.setCellCustomizer(new CapacityValueCellCustomizer(applicationContext));
        cellFactory.setAlignment(Pos.TOP_RIGHT);
        cellFactory.setContentDisplay(ContentDisplay.LEFT);
        this.setCellFactory(cellFactory);
    }
}

