/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.table.order;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.BasketEntry;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderStatus;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.BasketEntryContextMenu;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import com.deutscheboerse.ui.jfx.util.StyleUtil;
import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import com.deutscheboerse.ui.jfx.util.binding.DependentObservableValue;
import com.deutscheboerse.ui.jfx.util.binding.DependentObservableValue2;
import com.deutscheboerse.ui.jfx.util.binding.WeakObservableValue;
import com.deutscheboerse.ui.jfx.util.event.DeselectionEventHandler;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;

public class BasketOrderRowFactory
implements Callback<TableView<BasketEntry>, TableRow<BasketEntry>> {
    private final ApplicationContext appContext = FXMLLoaderWithContext.getAppContext();

    @Override
    public TableRow<BasketEntry> call(TableView<BasketEntry> orderTableView) {
        TableRow<BasketEntry> orderTableRow = new TableRow<BasketEntry>(){
            private final ObservableValue<String> rowErrorObservable;
            private final InvalidationListener rowErrorListener;
            {
                this.contextMenuProperty().bind(DependentBinding.get(item -> BasketEntryContextMenu.createContextMenu(item, BasketOrderRowFactory.this.appContext), this.itemProperty(), null, this.indexProperty()));
                this.rowErrorObservable = new DependentObservableValue<BasketEntry, String>(this, this.itemProperty(), new Observable[0]){

                    @Override
                    public ObservableValue<String> getObservableValue(BasketEntry basketEntry) {
                        return new WeakObservableValue<String>(basketEntry.getOrder().errorMessageProperty());
                    }
                };
                DependentObservableValue2<BasketEntry, OrderStatus> tableRowStatus = new DependentObservableValue2<BasketEntry, OrderStatus>(this.itemProperty(), b -> b.getOrder().statusProperty());
                tableRowStatus.addListener((observableValue, status, newStatus) -> StyleUtil.addStyleClass(this, "hibernate", newStatus == OrderStatus.HIBERNATE));
                1 that = this;
                this.rowErrorListener = observable2 -> FxUtil.runInFxThread(() -> {
                    BasketEntry basketEntry = (BasketEntry)this.getItem();
                    if (basketEntry != null && basketEntry.getOrder().getErrorMessage() != null && !basketEntry.getOrder().getErrorMessage().isEmpty()) {
                        StyleUtil.addStyleClass(that, "error");
                        this.setTooltip(new Tooltip(basketEntry.getOrder().getErrorMessage()));
                    } else {
                        this.getStyleClass().remove("error");
                        this.setTooltip(null);
                    }
                });
                WeakInvalidationListener weakRowErrorListener = new WeakInvalidationListener(this.rowErrorListener);
                this.rowErrorObservable.addListener(weakRowErrorListener);
            }
        };
        orderTableRow.addEventFilter((EventType<BasketEntry>)MouseEvent.MOUSE_PRESSED, (EventHandler<BasketEntry>)new DeselectionEventHandler<BasketEntry>(orderTableRow));
        return orderTableRow;
    }
}

