/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.table.order;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderStatus;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.contextmenu.OtcContextMenuFactory;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.order.OtcOrderRowTooltip;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import com.deutscheboerse.ui.jfx.util.StyleUtil;
import com.deutscheboerse.ui.jfx.util.binding.DependentObservableValue2;
import com.deutscheboerse.ui.jfx.util.event.DeselectionEventHandler;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;
import org.apache.commons.collections4.CollectionUtils;

public class OtcRowFactory
implements Callback<TableView<Order>, TableRow<Order>> {
    private final ApplicationContext appContext;

    public OtcRowFactory() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    protected OtcRowFactory(ApplicationContext applicationContext) {
        this.appContext = applicationContext;
    }

    @Override
    public TableRow<Order> call(TableView<Order> orderTableView) {
        OtcOrderTableRow otcOrderTableRow = new OtcOrderTableRow(this.appContext);
        otcOrderTableRow.updateTableView(orderTableView);
        return otcOrderTableRow;
    }

    private static final class OtcOrderTableRow
    extends TableRow<Order> {
        private final InvalidationListener userChangedListener;
        private final UserService userService;
        private final ObservableValue<User> userObservable;
        private final OtcOrderRowTooltip tooltip;
        private final OtcContextMenuFactory otcContextMenuFactory;

        public OtcOrderTableRow(ApplicationContext appContext) {
            this.userService = appContext.getService(UserService.class);
            this.tooltip = appContext.getService(OtcOrderRowTooltip.class);
            this.otcContextMenuFactory = appContext.getService(OtcContextMenuFactory.class);
            this.userChangedListener = observable2 -> this.setStyleForCurrentUser();
            this.userObservable = this.userService.currentUserProperty();
            this.userObservable.addListener(new WeakInvalidationListener(this.userChangedListener));
            this.setOnContextMenuRequested(contextMenuEvent -> {
                ObservableList selectedOtcOrders = this.getTableView().getSelectionModel().getSelectedItems();
                if (CollectionUtils.isNotEmpty(selectedOtcOrders)) {
                    this.setContextMenu(this.otcContextMenuFactory.createOtcContextMenu(selectedOtcOrders));
                }
            });
            this.tooltipProperty().bind(Bindings.when(this.itemProperty().isNotNull()).then(this.tooltip).otherwise((OtcOrderRowTooltip)null));
            this.setOnMouseEntered(mouseEvent -> this.tooltip.applyOrder((Order)this.getItem()));
            DependentObservableValue2<Order, OrderStatus> tableRowStatus = new DependentObservableValue2<Order, OrderStatus>(this.itemProperty(), Order::statusProperty);
            tableRowStatus.addListener((observableValue, status, newStatus) -> StyleUtil.addStyleClass(this, "hibernate", newStatus == OrderStatus.HIBERNATE || newStatus == OrderStatus.UNKNOWN));
            this.itemProperty().addListener((observableValue, order, newOrder) -> this.setStyleForCurrentUser());
            this.addEventFilter(MouseEvent.MOUSE_PRESSED, new DeselectionEventHandler<Order>(this));
        }

        private void setStyleForCurrentUser() {
            StyleUtil.addStyleClass(this, "currentUser", "nonCurrentUser", this.isCurrentUser((Order)this.getItem()));
        }

        private boolean isCurrentUser(Order order) {
            if (order != null) {
                User user = (User)this.userService.currentUserProperty().get();
                return user.getUserCode().equals(order.getTraderUserCode()) && ((String)user.getMember().getId()).equals(order.getMemberCode());
            }
            return false;
        }
    }
}

