/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.table.orderbook;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModel;
import com.deutscheboerse.comxerv.comtrader.entities.Member;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.ExtendedOrderbookEntry;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.ExtendedOrderbookEntryRow;
import com.deutscheboerse.comxerv.comtrader.entities.type.Direction;
import com.deutscheboerse.ui.jfx.util.binding.ConstantObservableValue;
import java.util.Optional;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TableColumn;
import javafx.util.Callback;

public class ExtendedOrderbookEntriesMemberCellValueFactory
implements Callback<TableColumn.CellDataFeatures<ExtendedOrderbookEntryRow, String>, ObservableValue<String>> {
    private final DataModel<Long, Order> orderDataModel;
    private final Direction direction;

    public ExtendedOrderbookEntriesMemberCellValueFactory(ApplicationContext applicationContext, Direction direction) {
        this.orderDataModel = applicationContext.getDataModel(Order.class);
        this.direction = direction;
    }

    @Override
    public ObservableValue<String> call(TableColumn.CellDataFeatures<ExtendedOrderbookEntryRow, String> param) {
        return Optional.ofNullable(param.getValue()).map(this::getOrder).map(this::getMemberDisplayName).orElse(ConstantObservableValue.EMPTY_STRING);
    }

    private Order getOrder(ExtendedOrderbookEntryRow entry) {
        ExtendedOrderbookEntry orderbookEntry = entry.getOrderbookEntry(this.direction);
        return orderbookEntry != null ? this.orderDataModel.findById(orderbookEntry.getOrderId()) : null;
    }

    private ObservableValue<String> getMemberDisplayName(Order order) {
        return Optional.ofNullable(order.getUser()).map(User::getMember).map(Member::displayNameProperty).orElse(order.memberCodeProperty());
    }
}

