/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.table.orderbook;

import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.CommonOrderbookEntry;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.ComputedOrderbookEntries;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.listener.BatchUpdatable;
import com.deutscheboerse.comxerv.comtrader.entities.property.binding.LongDisplayValueStringBinding;
import com.deutscheboerse.comxerv.comtrader.entities.type.Direction;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.CollapsibleValueOrderbookWrapper;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.orderbook.CollapsibleOrderbookEntries;
import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import java.util.function.Function;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TableColumn;
import javafx.util.Callback;

public class OrderbookEntriesValueFactory
implements Callback<TableColumn.CellDataFeatures<CollapsibleValueOrderbookWrapper, CollapsibleOrderbookEntries>, ObservableValue<CollapsibleOrderbookEntries>> {
    private Direction direction = Direction.BUY;
    private ValueToDisplayProperty valueToDisplay = ValueToDisplayProperty.PRICE;

    @Override
    public ObservableValue<CollapsibleOrderbookEntries> call(TableColumn.CellDataFeatures<CollapsibleValueOrderbookWrapper, CollapsibleOrderbookEntries> param) {
        CollapsibleValueOrderbookWrapper value = param.getValue();
        ReadOnlyObjectProperty<ComputedOrderbookEntries> entriesValue = this.getDirection().isBuy() ? value.buysProperty() : value.sellsProperty();
        return DependentBinding.get(() -> {
            Orderbook orderbook = value.getOrderbook();
            if (orderbook != null && entriesValue.getValue() != null) {
                return new CollapsibleOrderbookEntries(value.collapsedProperty(), ((ComputedOrderbookEntries)entriesValue.getValue()).getEntries(), (BatchUpdatable)entriesValue.getValue(), value.rowLimitProperty(), this.getDirection(), ((ComputedOrderbookEntries)entriesValue.getValue()).getBestEntry(), orderbook, this.valueToDisplay.displayValueFunction, this.valueToDisplay.exportValueFunction);
            }
            return null;
        }, entriesValue);
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public ValueToDisplayProperty getValueToDisplay() {
        return this.valueToDisplay;
    }

    public void setValueToDisplay(ValueToDisplayProperty valueToDisplay) {
        this.valueToDisplay = valueToDisplay;
    }

    public static enum ValueToDisplayProperty {
        ACC_QUANTITY(CommonOrderbookEntry::accQuantityProperty, true),
        PRICE(CommonOrderbookEntry::priceProperty, true),
        FIRM_QUANTITY(CommonOrderbookEntry::quantityProperty, false),
        VWAP(CommonOrderbookEntry::vwapProperty, false),
        OWN_FIRM_QUANTITY(CommonOrderbookEntry::ownQuantityProperty, false);

        private Function<CommonOrderbookEntry, ObservableValue<String>> displayValueFunction;
        private Function<CommonOrderbookEntry, Object> exportValueFunction;

        private ValueToDisplayProperty(Function<CommonOrderbookEntry, ObservableValue<LongDisplayValue>> displayValueFunction, boolean displayZero) {
            this.displayValueFunction = entry -> new LongDisplayValueStringBinding((ObservableValue)displayValueFunction.apply((CommonOrderbookEntry)entry), displayZero);
            this.exportValueFunction = entry -> ((ObservableValue)displayValueFunction.apply((CommonOrderbookEntry)entry)).getValue();
        }

        private ValueToDisplayProperty(Function<CommonOrderbookEntry, ObservableValue<String>> displayValueFunction) {
            this.displayValueFunction = displayValueFunction;
            this.exportValueFunction = entry -> ((ObservableValue)displayValueFunction.apply((CommonOrderbookEntry)entry)).getValue();
        }
    }
}

