/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.table.storage;

import com.deutscheboerse.comxerv.comtrader.jfx.components.table.CustomTableView;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.SeparatorTableColumn;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.storage.StorableTableColumnDescriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javafx.collections.ObservableList;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import org.apache.commons.lang3.StringUtils;

public class StorableTableLayoutDescriptor<S>
implements Serializable {
    private final Map<String, StorableTableColumnDescriptor> columnDescriptors;
    private final List<String> sortOrder;
    private static final long serialVersionUID = 1L;

    private StorableTableLayoutDescriptor(Map<String, StorableTableColumnDescriptor> columnDescriptors, List<String> sortOrder) {
        this.columnDescriptors = columnDescriptors;
        this.sortOrder = sortOrder;
    }

    public static <S> StorableTableLayoutDescriptor<S> fromTable(TableView<S> tableView, boolean onlyVisibleColumns) {
        LinkedHashMap<String, StorableTableColumnDescriptor> descriptorsForColumnsWithId = new LinkedHashMap<String, StorableTableColumnDescriptor>();
        for (TableColumn tableColumn : tableView.getColumns()) {
            if (!StorableTableLayoutDescriptor.isStorableColumn(tableColumn, onlyVisibleColumns)) continue;
            descriptorsForColumnsWithId.put(tableColumn.getId(), StorableTableColumnDescriptor.fromTableColumn(tableColumn));
        }
        ArrayList<String> sortOrder = new ArrayList<String>(tableView.getSortOrder().size());
        for (TableColumn tableColumn : tableView.getSortOrder()) {
            if (!StorableTableLayoutDescriptor.isStorableColumn(tableColumn, onlyVisibleColumns)) continue;
            sortOrder.add(tableColumn.getId());
        }
        return new StorableTableLayoutDescriptor<S>(descriptorsForColumnsWithId, sortOrder);
    }

    private static boolean isStorableColumn(TableColumn<?, ?> tableColumn, boolean onlyVisibleColumns) {
        return StringUtils.isNotBlank(tableColumn.getId()) && (!onlyVisibleColumns || tableColumn.isVisible());
    }

    public static <S> StorableTableLayoutDescriptor<S> fromTable(TableView<S> tableView) {
        return StorableTableLayoutDescriptor.fromTable(tableView, false);
    }

    public void applyToTable(CustomTableView<S> tableView) {
        this.applyColumnsProperties(tableView);
        this.restoreOrderingOfColumns(tableView);
        this.restoreSortOrder(tableView);
    }

    public void restoreSortOrder(TableView<S> tableView) {
        if (this.sortOrder == null) {
            return;
        }
        tableView.getSortOrder().clear();
        block0: for (String id : this.sortOrder) {
            for (TableColumn tableColumn : tableView.getColumns()) {
                if (!id.equals(tableColumn.getId())) continue;
                tableView.getSortOrder().add(tableColumn);
                continue block0;
            }
        }
    }

    private void restoreOrderingOfColumns(CustomTableView<S> tableView) {
        ObservableList columns = tableView.getColumns();
        int index = 0;
        block0: for (Map.Entry<String, StorableTableColumnDescriptor> entry : this.columnDescriptors.entrySet()) {
            if (entry.getKey().startsWith("separator")) {
                SeparatorTableColumn<S> column = tableView.addSeparator(entry.getKey());
                entry.getValue().applyToTableColumn(column);
                columns.remove(column);
                columns.add(index++, column);
                continue;
            }
            for (TableColumn tableColumn : columns) {
                if (!entry.getKey().equals(tableColumn.getId())) continue;
                columns.remove(tableColumn);
                columns.add(index++, tableColumn);
                continue block0;
            }
        }
    }

    private void applyColumnsProperties(TableView<S> tableView) {
        ObservableList<TableColumn<S, ?>> columns = tableView.getColumns();
        for (TableColumn tableColumn : columns) {
            if (!this.columnDescriptors.containsKey(tableColumn.getId())) continue;
            this.columnDescriptors.get(tableColumn.getId()).applyToTableColumn(tableColumn);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("StorableTableLayoutDescriptor(\n");
        for (Map.Entry<String, StorableTableColumnDescriptor> entry : this.columnDescriptors.entrySet()) {
            sb.append("    " + entry.getKey() + ":" + String.valueOf(entry.getValue()) + "\n");
        }
        sb.append(")");
        return sb.toString();
    }

    public Map<String, StorableTableColumnDescriptor> getColumnDescriptors() {
        return this.columnDescriptors;
    }
}

