/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.excel;

import com.deutscheboerse.comxerv.comtrader.entities.orderbook.ExtendedOrderbookEntry;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.AbstractOrderbookPane;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.excel.ExcelHeadersStrategy;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.excel.ExcelOverviewStrategy;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.excel.ExcelRowsStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelStrategiesSetup {
    private static final Logger LOG = LoggerFactory.getLogger(ExcelStrategiesSetup.class);
    private ExcelOverviewStrategy<Orderbook> overviewStrategy;
    private ExcelHeadersStrategy<Orderbook> headersStrategy;
    private ExcelRowsStrategy<AbstractOrderbookPane, ExtendedOrderbookEntry> rowsStrategy;

    protected ExcelStrategiesSetup() {
    }

    public ExcelStrategiesSetup(ExcelOverviewStrategy<Orderbook> overviewStrategy, ExcelRowsStrategy<AbstractOrderbookPane, ExtendedOrderbookEntry> rowsStrategy, ExcelHeadersStrategy<Orderbook> headersStrategy) {
        if (overviewStrategy == null || rowsStrategy == null || headersStrategy == null) {
            LOG.error("One of strategies is null! overviewStrategy: {} rowsStrategy: {}, headersStrategy: {}", overviewStrategy, rowsStrategy, headersStrategy);
            throw new IllegalArgumentException("One of strategies is null, check logs!");
        }
        this.overviewStrategy = overviewStrategy;
        this.rowsStrategy = rowsStrategy;
        this.headersStrategy = headersStrategy;
    }

    public ExcelOverviewStrategy<Orderbook> getOverviewStrategy() {
        return this.overviewStrategy;
    }

    public ExcelHeadersStrategy<Orderbook> getHeadersStrategy() {
        return this.headersStrategy;
    }

    public ExcelRowsStrategy<AbstractOrderbookPane, ExtendedOrderbookEntry> getRowsStrategy() {
        return this.rowsStrategy;
    }

    public void setOverviewStrategy(ExcelOverviewStrategy<Orderbook> overviewStrategy) {
        this.overviewStrategy = overviewStrategy;
    }

    public void setHeadersStrategy(ExcelHeadersStrategy<Orderbook> headersStrategy) {
        this.headersStrategy = headersStrategy;
    }

    public void setRowsStrategy(ExcelRowsStrategy<AbstractOrderbookPane, ExtendedOrderbookEntry> rowsStrategy) {
        this.rowsStrategy = rowsStrategy;
    }

    public static ExcelStrategiesSetup blank() {
        return new ExcelStrategiesSetup();
    }
}

