/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.service;

import com.deutscheboerse.comxerv.comtrader.core.util.DisplayName;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.scene.paint.Color;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Theme
implements DisplayName {
    private final String name;
    private final String cssPath;
    private final boolean isValid;
    private final Color flashColor;
    private static final Logger LOG = LoggerFactory.getLogger(Theme.class);
    protected static final ThemeColor FLASH_COLOR = new ThemeColor("flash-color", Color.YELLOW);
    private static final Pattern COLOR_DEFINITION_PATTERN = Pattern.compile("\\p{ASCII}*:[^;]*");

    public Theme(String name, String cssPath) {
        this(name, cssPath, () -> Theme.readCss(cssPath));
    }

    protected Theme(String name, String cssPath, Supplier<List<String>> colorDefinitionsSupplier) {
        this.name = name;
        this.cssPath = cssPath;
        List<String> colorDefinitions = colorDefinitionsSupplier.get();
        this.isValid = !colorDefinitions.isEmpty();
        this.flashColor = this.getColorValue(FLASH_COLOR, colorDefinitions);
    }

    private Color getColorValue(ThemeColor themeColor, List<String> colorDefinitions) {
        return colorDefinitions.stream().map(definition -> this.getColorValue(themeColor, (String)definition)).filter(Optional::isPresent).map(Optional::get).findAny().orElse(themeColor.getDefaultValue());
    }

    private Optional<Color> getColorValue(ThemeColor color, String line) {
        String[] split;
        Matcher matcher = COLOR_DEFINITION_PATTERN.matcher(line);
        if (matcher.find() && (split = matcher.group().split(":")).length == 2 && color.getCssName().equals(split[0].trim())) {
            try {
                return Optional.of(Color.web(split[1].trim()));
            }
            catch (IllegalArgumentException e) {
                LOG.error("Error while parsing color: {} for property {}. Applying default color.", (Object)split[1], (Object)color.getCssName());
            }
        }
        return Optional.empty();
    }

    private static List<String> readCss(String cssPath) {
        List<String> list;
        block9: {
            URL url;
            URL uRL = url = cssPath.startsWith("/") ? Theme.class.getResource(cssPath) : Theme.class.getClassLoader().getResource(cssPath);
            if (url == null) {
                LOG.error("Could not read color theme from path {}.", (Object)cssPath);
                return Collections.emptyList();
            }
            InputStream inputStream = url.openStream();
            try {
                list = IOUtils.readLines(inputStream, StandardCharsets.UTF_8);
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.error("Could not read color theme.");
                    return Collections.emptyList();
                }
            }
            inputStream.close();
        }
        return list;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    public String getCssPath() {
        return this.cssPath;
    }

    public Color getFlashColor() {
        return this.flashColor;
    }

    public boolean isDeletable() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Theme theme = (Theme)o;
        if (this.name != null ? !this.name.equals(theme.name) : theme.name != null) {
            return false;
        }
        return !(this.cssPath != null ? !this.cssPath.equals(theme.cssPath) : theme.cssPath != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.cssPath != null ? this.cssPath.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Theme{name='" + this.name + "', path='" + this.cssPath + "'}";
    }

    protected static class ThemeColor {
        private final String cssName;
        private final Color defaultValue;

        public ThemeColor(String cssName, Color defaultValue) {
            this.cssName = cssName;
            this.defaultValue = defaultValue;
        }

        public Color getDefaultValue() {
            return this.defaultValue;
        }

        public String getCssName() {
            return this.cssName;
        }
    }
}

