/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.service.amqp;

import com.deutscheboerse.comxerv.comtrader.entities.session.Session;
import com.deutscheboerse.comxerv.comtrader.module.WorkerExecutor;
import com.deutscheboerse.comxerv.comtrader.service.amqp.ObjectHandler;
import com.deutscheboerse.comxerv.comtrader.service.amqp.UiThreadObjectHandler;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

@Singleton
public class FxThreadObjectHandler
implements UiThreadObjectHandler {
    protected static final long HANDLING_DELAY_IN_MILLIS = 150L;
    protected static final long MAX_HANDLING_TIME_IN_MILLIS = 300L;
    private static final long PROCESSING_DURATION_WARNING_THRESHOLD_IN_MILLIS = 300L;
    private static final Logger LOG = LoggerFactory.getLogger(FxThreadObjectHandler.class);
    private static final Logger PERFORMANCE_LOG = LoggerFactory.getLogger("performance");
    private static final Marker PROCESSING_MARKER = MarkerFactory.getMarker("PROCESSING");
    private static final Marker PROCESSING_QUEUE_MARKER = MarkerFactory.getMarker("PROCESSING_QUEUE");
    private final ScheduledExecutorService scheduledExecutorService;
    private final Set<ObjectHandler<Object>> handlers;
    private final Queue<Runnable> queue;

    @Inject
    public FxThreadObjectHandler(@WorkerExecutor ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = scheduledExecutorService;
        this.handlers = ConcurrentHashMap.newKeySet();
        this.queue = new ConcurrentLinkedQueue<Runnable>();
        this.schedule();
    }

    @Override
    public ObjectHandler.Result handleObject(Session session, Object object, String correlationId) {
        long startTimeStamp = this.currentTimeMillis();
        this.queue.add(() -> this.doHandleObject(session, object, correlationId, startTimeStamp));
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} {} added to queue (size: {})", object.getClass().getSimpleName(), correlationId, this.queue.size());
        }
        return ObjectHandler.Result.RETAIN;
    }

    private void handleObjectsInFxThread() {
        int queueSize = this.queue.size();
        if (queueSize > 0) {
            if (PERFORMANCE_LOG.isDebugEnabled(PROCESSING_QUEUE_MARKER)) {
                PERFORMANCE_LOG.debug(PROCESSING_QUEUE_MARKER, Integer.toString(queueSize));
            }
            long start = this.currentTimeMillis();
            while (!this.queue.isEmpty()) {
                Runnable objectHandling = this.queue.poll();
                objectHandling.run();
                long duration = this.currentTimeMillis() - start;
                if (duration <= 300L) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("MAX_HANDLING_TIME_IN_MILLIS reached, rescheduling, remaining: {}", (Object)this.queue.size());
                }
                this.runLater(this::handleObjectsInFxThread);
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Done, size: {}", (Object)this.queue.size());
            }
        }
        this.schedule();
    }

    private void schedule() {
        try {
            this.scheduledExecutorService.schedule(this.wrapWithRunInFxThread(this::handleObjectsInFxThread), 150L, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException e) {
            LOG.debug("We're shutting down but there are still some broadcasts in the processing queue - ignoring.");
        }
    }

    private void doHandleObject(Session session, Object object, String correlationId, long startTimeStamp) {
        LOG.debug("Start processing: {} {}", (Object)object.getClass().getSimpleName(), (Object)correlationId);
        long processingStartTimeStamp = this.currentTimeMillis();
        this.handlers.removeIf(handler -> handler.handleObject(session, object, correlationId) == ObjectHandler.Result.REMOVE);
        long endTimeStamp = this.currentTimeMillis();
        long broadcastProcessingTime = endTimeStamp - startTimeStamp;
        long netBroadcastProcessingTime = endTimeStamp - processingStartTimeStamp;
        long waitTime = processingStartTimeStamp - startTimeStamp;
        if (PERFORMANCE_LOG.isDebugEnabled(PROCESSING_MARKER)) {
            PERFORMANCE_LOG.debug(PROCESSING_MARKER, "{} {} {} {} {}", Long.toString(broadcastProcessingTime), Long.toString(netBroadcastProcessingTime), Long.toString(waitTime), object.getClass().getSimpleName(), correlationId);
        }
        if (netBroadcastProcessingTime > 300L) {
            LOG.warn("Long broadcast processing of {} {} - {}ms", object.getClass().getSimpleName(), correlationId, netBroadcastProcessingTime);
            if (LOG.isDebugEnabled()) {
                String message = object.toString();
                LOG.debug("First 1000 chars: {}", (Object)message.substring(0, Math.min(message.length(), 1000)));
            }
        }
        LOG.debug("Processed: {} {} in {}", object.getClass().getSimpleName(), correlationId, netBroadcastProcessingTime);
    }

    @Override
    public void addObjectHandler(ObjectHandler<Object> objectHandler) {
        this.handlers.add(objectHandler);
    }

    @Override
    public void removeObjectHandler(ObjectHandler<Object> objectHandler) {
        this.handlers.remove(objectHandler);
    }

    protected long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    protected Runnable wrapWithRunInFxThread(Runnable runnable) {
        return FxUtil.wrapWithRunInFxThread(runnable);
    }

    protected void runLater(Runnable runnable) {
        FxUtil.runLater(runnable);
    }
}

